/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.util.ArrayList;
import java.util.List;

public class ModuleImport
implements Annotated {
    private boolean optional;
    private boolean export;
    private String namespace;
    private Module module;
    private Backends nativeBackends;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private ModuleImport overridenModuleImport = null;

    public ModuleImport(String namespace, Module module, boolean optional, boolean export) {
        this(namespace, module, optional, export, (Backend)null);
    }

    public ModuleImport(String namespace, Module module, boolean optional, boolean export, Backend backend) {
        this(namespace, module, optional, export, backend != null ? backend.asSet() : Backends.ANY);
    }

    public ModuleImport(String namespace, Module module, boolean optional, boolean export, Backends backends) {
        this.namespace = namespace;
        this.module = module;
        this.optional = optional;
        this.export = export;
        this.nativeBackends = backends;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isExport() {
        return this.export;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isNative() {
        return !this.getNativeBackends().none();
    }

    public Backends getNativeBackends() {
        return this.nativeBackends;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public ModuleImport getOverridenModuleImport() {
        return this.overridenModuleImport;
    }

    public boolean override(ModuleImport moduleImportOverride) {
        if (this.overridenModuleImport == null && moduleImportOverride != null) {
            this.overridenModuleImport = new ModuleImport(this.namespace, this.module, this.optional, this.export, this.nativeBackends);
            this.namespace = moduleImportOverride.getNamespace();
            this.module = moduleImportOverride.getModule();
            this.optional = moduleImportOverride.isOptional();
            this.export = moduleImportOverride.isExport();
            this.nativeBackends = moduleImportOverride.getNativeBackends();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.export) {
            sb.append("shared ");
        }
        if (this.optional) {
            sb.append("optional ");
        }
        if (!this.nativeBackends.none()) {
            sb.append(this.nativeBackends);
        }
        sb.append("import ");
        if (this.namespace != null) {
            sb.append("\"").append(this.namespace).append(":").append(this.module.getNameAsString()).append("\"");
        } else {
            sb.append(this.module.getNameAsString());
        }
        sb.append(" \"").append(this.module.getVersion()).append("\"");
        return sb.toString();
    }
}

