/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.util;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ModuleManager {
    public static final String MODULE_FILE = "module.ceylon";
    public static final String PACKAGE_FILE = "package.ceylon";
    protected Modules modules;

    public Package createPackage(String pkgName, Module module) {
        Package pkg = new Package();
        List<String> name = pkgName.isEmpty() ? Arrays.asList("") : ModuleManager.splitModuleName(pkgName);
        pkg.setName(name);
        if (module != null) {
            module.getPackages().add(pkg);
            pkg.setModule(module);
        }
        return pkg;
    }

    public void initCoreModules(Modules initialModules) {
        this.modules = initialModules;
        if (this.modules.getLanguageModule() == null) {
            Package emptyPackage = this.createPackage("", null);
            List<String> defaultModuleName = Collections.singletonList("default");
            Module defaultModule = this.createModule(defaultModuleName, "unversioned");
            defaultModule.setAvailable(true);
            this.bindPackageToModule(emptyPackage, defaultModule);
            this.modules.getListOfModules().add(defaultModule);
            this.modules.setDefaultModule(defaultModule);
            List<String> languageName = Arrays.asList("ceylon", "language");
            Module languageModule = this.createModule(languageName, "1.3.2");
            languageModule.setLanguageModule(languageModule);
            languageModule.setAvailable(false);
            this.modules.setLanguageModule(languageModule);
            this.modules.getListOfModules().add(languageModule);
            defaultModule.addImport(new ModuleImport(null, languageModule, false, false));
            defaultModule.setLanguageModule(languageModule);
        }
    }

    public void bindPackageToModule(Package pkg, Module module) {
        if (pkg.getModule() != null) {
            pkg.getModule().getPackages().remove(pkg);
            pkg.setModule(null);
        }
        module.getPackages().add(pkg);
        pkg.setModule(module);
    }

    protected Module createModule(List<String> moduleName, String version2) {
        Module module = new Module();
        module.setName(moduleName);
        module.setVersion(version2);
        return module;
    }

    public Module getOrCreateModule(List<String> moduleName, String version2) {
        if (moduleName.isEmpty()) {
            return null;
        }
        Module module = null;
        Set<Module> moduleList = this.modules.getListOfModules();
        for (Module current : moduleList) {
            List<String> names = current.getName();
            if (!moduleName.equals(names) || !this.compareVersions(current, version2, current.getVersion())) continue;
            module = current;
            break;
        }
        if (module == null) {
            module = this.createModule(moduleName, version2);
            module.setLanguageModule(this.modules.getLanguageModule());
            moduleList.add(module);
        }
        return module;
    }

    protected boolean compareVersions(Module current, String version2, String currentVersion) {
        return currentVersion == null || version2 == null || currentVersion.equals(version2);
    }

    public ModuleImport findImport(Module owner, Module dependency) {
        for (ModuleImport modImprt : owner.getImports()) {
            if (!this.equalsForModules(modImprt.getModule(), dependency, true)) continue;
            return modImprt;
        }
        return null;
    }

    public boolean equalsForModules(Module left, Module right, boolean exactVersionMatch) {
        if (left == right) {
            return true;
        }
        List<String> leftName = left.getName();
        List<String> rightName = right.getName();
        if (leftName.size() != rightName.size()) {
            return false;
        }
        for (int index = 0; index < leftName.size(); ++index) {
            if (leftName.get(index).equals(rightName.get(index))) continue;
            return false;
        }
        return !exactVersionMatch || left.getVersion() != null && left.getVersion().equals(right.getVersion());
    }

    public Module findModule(Module module, List<Module> listOfModules, boolean exactVersionMatch) {
        for (Module current : listOfModules) {
            if (!this.equalsForModules(module, current, exactVersionMatch)) continue;
            return current;
        }
        return null;
    }

    public boolean similarForModules(Module left, Module right) {
        if (left == right) {
            return true;
        }
        String leftName = ModuleUtil.toCeylonModuleName(left.getNameAsString());
        String rightName = ModuleUtil.toCeylonModuleName(right.getNameAsString());
        return leftName.equals(rightName);
    }

    public Module findSimilarModule(Module module, List<Module> listOfModules) {
        for (Module current : listOfModules) {
            if (!this.similarForModules(module, current)) continue;
            return current;
        }
        return null;
    }

    public Module findLoadedModule(String moduleName, String searchedVersion) {
        return this.findLoadedModule(moduleName, searchedVersion, this.modules);
    }

    @Deprecated
    private final Module findLoadedModule(String moduleName, String searchedVersion, Modules modules) {
        if (moduleName.equals("default")) {
            return modules.getDefaultModule();
        }
        for (Module module : modules.getListOfModules()) {
            if (!module.getNameAsString().equals(moduleName) || !this.compareVersions(module, searchedVersion, module.getVersion())) continue;
            return module;
        }
        return null;
    }

    public Iterable<String> getSearchedArtifactExtensions() {
        return Arrays.asList("src");
    }

    public static List<String> splitModuleName(String moduleName) {
        return Arrays.asList(moduleName.split("[\\.]"));
    }

    public void prepareForTypeChecking() {
    }

    public void addImplicitImports() {
    }

    public void modulesVisited() {
    }

    public void visitedModule(Module module, boolean forCompiledModule) {
    }

    public Module overridesModule(ArtifactResult artifact, Module module, ModuleImport moduleImport) {
        String namespace = artifact.namespace();
        String realName = artifact.name();
        String realVersion = artifact.version();
        if (!(realName.equals(module.getNameAsString()) && realVersion.equals(module.getVersion()) || module == module.getLanguageModule())) {
            Module realModule = this.getOrCreateModule(ModuleManager.splitModuleName(realName), realVersion);
            moduleImport.override(new ModuleImport(namespace, realModule, moduleImport.isOptional(), moduleImport.isExport()));
            return realModule;
        }
        return null;
    }

    public Modules getModules() {
        return this.modules;
    }

    protected void setModules(Modules modules) {
        this.modules = modules;
    }

    public Backends getSupportedBackends() {
        return Backends.ANY;
    }

    public boolean isManualMetamodelSetup() {
        return true;
    }
}

