/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.classpath;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.File;
import java.io.IOException;
import java.util.List;

@Summary(value="Prints a classpath suitable for passing to Java tools to run a given Ceylon module")
@Description(value="Will print a classpath for a given set of Ceylon modules, suitable for use with Java tools to run a given Ceylon module outside of the regular JBoss Modules container used in `ceylon run`. If you need to force inclusion of optional modules, you can specify them as additional modules after your main module.")
public class CeylonClasspathTool
extends ModuleLoadingTool {
    private List<ModuleSpec> modules;
    private boolean force;

    @Argument(argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Option(longName="force")
    @Description(value="Force generation of classpath with multiple versions of the same module.")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public void run() throws Exception {
        this.loadModule(null, "com.redhat.ceylon.java.main", "1.3.2");
        for (ModuleSpec module : this.modules) {
            String moduleName = module.getName();
            String version2 = this.checkModuleVersionsOrShowSuggestions(moduleName, module.isVersioned() ? module.getVersion() : null, ModuleQuery.Type.JVM, 8, 1, null, null, null);
            if (version2 == null) continue;
            this.loadModule(null, moduleName, version2);
            if (this.force) continue;
            this.errorOnConflictingModule(moduleName, version2);
        }
        this.loader.resolve();
        this.loader.visitModules(new ModuleGraph.Visitor(){
            boolean once = true;

            @Override
            public void visit(ModuleGraph.Module module) {
                if (module.artifact != null) {
                    File file = module.artifact.artifact();
                    try {
                        if (file != null) {
                            if (this.once) {
                                this.once = false;
                            } else {
                                CeylonClasspathTool.this.append(File.pathSeparator);
                            }
                            CeylonClasspathTool.this.append(file.getAbsolutePath());
                        }
                    }
                    catch (IOException x) {
                        throw new RuntimeException(x);
                    }
                }
            }
        });
        this.flush();
    }
}

