/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.new_;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.tools.new_.Environment;
import com.redhat.ceylon.tools.new_.Template;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;

public class Copy {
    private final PathMatcher pathMatcher;
    private final boolean substitute;
    private final File from;
    private final File basedir;

    public Copy(File from, File basedir, PathMatcher pathMatcher, String dst, boolean substitute) {
        this.from = from;
        this.basedir = new File(basedir, dst);
        this.pathMatcher = pathMatcher;
        this.substitute = substitute;
    }

    public void run(Environment env) throws IOException {
        Files.walkFileTree(this.from.toPath(), new CopyingVisitor(env, this.from.toPath(), this.pathMatcher, this.basedir.toPath(), this.substitute));
    }

    public String toString() {
        return "Copy from=" + this.from + ", basedir=" + this.basedir + ", matching=" + this.pathMatcher + ", substituting=" + this.substitute;
    }

    private static final class CopyingVisitor
    extends SimpleFileVisitor<Path> {
        private final Environment env;
        private final Path basedir;
        private final Path root;
        private final PathMatcher pathMatcher;
        private final boolean substitute;

        private CopyingVisitor(Environment env, Path root, PathMatcher pathMatcher, Path basedir, boolean substitute) {
            this.env = env;
            this.root = root;
            this.pathMatcher = pathMatcher;
            this.basedir = basedir;
            this.substitute = substitute;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            Path rel = this.root.relativize(path);
            if (this.pathMatcher.matches(rel)) {
                Path dstPath = this.basedir.resolve(rel);
                try {
                    this.copy(path, dstPath);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while copying " + path + " to " + dstPath, e);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private void copy(Path path, Path dstPath) throws IOException {
            File dstParent = dstPath.toFile().getParentFile();
            if (!dstParent.exists() && !FileUtil.mkdirs(dstParent)) {
                throw new IOException("Unable to mkdir " + dstParent);
            }
            if (this.substitute) {
                Files.copy(this.substitute(path, this.env), dstPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(path, dstPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }

        private InputStream substitute(Path path, Environment env) throws IOException {
            File file = path.toFile();
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new RuntimeException("File way too big for in-memory substitution");
            }
            Template.SimpleSubstitution subs = new Template.SimpleSubstitution(env);
            try (FileChannel channel = new FileInputStream(file).getChannel();){
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)length);
                channel.read(byteBuffer);
                byteBuffer.flip();
                Template template = new Template(Charset.forName("UTF-8").decode(byteBuffer));
                String substituted = template.eval(subs);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(substituted.getBytes("UTF-8"));
                return byteArrayInputStream;
            }
        }
    }
}

