/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.war;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import com.redhat.ceylon.tools.war.CeylonWarMessages;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

@Summary(value="Generates a WAR file from a compiled `.car` file")
@Description(value="Generates a WAR file from the `.car` file of the given `module-with-version`, suitable for deploying to a standard Servlet container.\n\nThe version number is required since, in general, there can be multiple versions available in the configured repositories.\n\nThe given module's `.car` file and those of its transitive dependencies will be copied to the `WEB-INF/lib` of the generated WAR file. Dependencies which are provided by the application container (and thus not required to be in `WEB-INF/lib`) can be excluded using `--provided-module`.")
@RemainingSections(value="## Static metamodel or WarInitializer \n\nCeylon can set up the run-time metamodel using either a listener (ceylon.war.WarInitializer) that is set in the default web.xml. Or by generating a static metamodel file.\n\n## Static metamodel \n\nIf you want to run on WildFly or other application servers that remove provided jars from the `lib/` folder, you should try the `--static-metamodel` argument and marking your provided modules with `--provided-module`.\n\n## WarInitializer \n\nOn non-WildFly application servers you should leave `ceylon war` do the default of generating a `web.xml` file for you which will call the `WarInitializer` listener to set up the metamodel based on the contents of the `lib/` folder at run-time.\n\n### Overriding web.xml\n\nIf you provide a custom `WEB-INF/web.xml` file in your WAR resource-root, you'll need to include the listener (ceylon.war.WarInitializer) that is set in the default web.xml. Without that listener, the metamodel will not be properly initialized.\n\n## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see https://ceylon-lang.org/documentation/1.3/reference/repository/tools")
public class CeylonWarTool
extends ModuleLoadingTool {
    static final String WAR_MODULE = "com.redhat.ceylon.war";
    private List<ModuleSpec> modules;
    private final List<EntrySpec> entrySpecs = new ArrayList<EntrySpec>();
    private final List<String> excludedModules = new ArrayList<String>();
    private final List<String> providedModules = new ArrayList<String>();
    private String out = null;
    private String name = null;
    private String resourceRoot;
    private boolean staticMetamodel;

    @Option(longName="static-metamodel")
    @Description(value="Generate a static metamodel, skip the WarInitializer (default: false).")
    public void setStaticMetamodel(boolean staticMetamodel) {
        this.staticMetamodel = staticMetamodel;
    }

    @Argument(argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @OptionArgument(shortName=111, argumentName="dir")
    @Description(value="Sets the output directory for the WAR file (default: .)")
    public void setOut(String out) {
        this.out = out;
    }

    @OptionArgument(shortName=110, argumentName="name")
    @Description(value="Sets name of the WAR file (default: moduleName-version.war)")
    public void setName(String name) {
        this.name = name;
    }

    @OptionArgument(shortName=82, argumentName="directory")
    @Description(value="Sets the special resource directory whose files will end up in the root of the resulting WAR file (default: web-content).")
    public void setResourceRoot(String root) {
        this.resourceRoot = root;
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=120)
    @Description(value="Excludes modules from the WAR file. Can be a module name or a file containing module names. Can be specified multiple times. Note that this excludes the module from the WAR file, but if your modules require that module to be present at runtime it will still be required and may cause your application to fail to start if it is not provided at runtime.")
    public void setExcludeModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.excludedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonWarMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.excludedModules.add(each);
        }
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=112)
    @Description(value="Excludes modules from the WAR file by treating them as provided. Can be a module name or a file containing module names. Can be specified multiple times. Note that this excludes the module from the WAR file, but if your modules require that module to be present at runtime it will still be required and may cause your application to fail to start if it is not provided at runtime. The only difference between this and `--exclude-module` is that provided modules are listed in the metamodel.")
    public void setProvidedModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.providedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonWarMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.providedModules.add(each);
        }
    }

    @Override
    protected boolean skipDependency(ArtifactResult dep) {
        return dep.moduleScope() == ModuleScope.PROVIDED;
    }

    @Override
    public void run() throws Exception {
        String moduleName = null;
        String moduleVersion = null;
        Properties properties = new Properties();
        for (ModuleSpec module : this.modules) {
            String name = module.getName();
            String version2 = this.checkModuleVersionsOrShowSuggestions(name, module.isVersioned() ? module.getVersion() : null, ModuleQuery.Type.JVM, 8, 1, null, null, null);
            if (version2 == null) continue;
            if (!this.loadModule(null, name, version2)) {
                throw new ToolUsageError(CeylonWarMessages.msg("abort.missing.modules", new Object[0]));
            }
            if (moduleName != null) continue;
            moduleName = name;
            moduleVersion = version2;
        }
        if (!this.staticMetamodel && !this.loadModule(null, WAR_MODULE, "1.3.2")) {
            throw new ToolUsageError(CeylonWarMessages.msg("abort.missing.modules", new Object[0]));
        }
        this.loader.resolve();
        ArrayList<ArtifactResult> staticMetamodelEntries = new ArrayList<ArtifactResult>();
        this.addLibEntries(staticMetamodelEntries);
        properties.setProperty("moduleName", moduleName);
        properties.setProperty("moduleVersion", moduleVersion);
        this.addSpec(new PropertiesEntrySpec(properties, "META-INF/module.properties"));
        if (!this.addResources(this.entrySpecs) && !this.staticMetamodel) {
            this.debug("adding.entry", "default web.xml");
            this.addSpec(new URLEntrySpec(CeylonWarTool.class.getClassLoader().getResource("com/redhat/ceylon/tools/war/resources/default-web.xml"), "WEB-INF/web.xml"));
        }
        if (this.name == null) {
            this.name = moduleVersion != null && !moduleVersion.isEmpty() ? String.format("%s-%s.war", moduleName, moduleVersion) : String.format("%s.war", moduleName);
            this.debug("default.name", this.name);
        }
        File jarFile = this.getJarFile();
        this.writeJarFile(jarFile, staticMetamodelEntries);
        String descr = moduleVersion != null && !moduleVersion.isEmpty() ? moduleName + "/" + moduleVersion : moduleName;
        this.append(CeylonWarMessages.msg("archive.created", descr, jarFile.getAbsolutePath()));
        this.newline();
    }

    public File getJarFile() {
        return this.applyCwd(this.out == null ? new File(this.name) : new File(this.out, this.name));
    }

    @Override
    protected boolean shouldExclude(String moduleName, String version2) {
        return super.shouldExclude(moduleName, version2) || this.excludedModules.contains(moduleName);
    }

    @Override
    protected boolean isProvided(String moduleName, String version2) {
        return super.isProvided(moduleName, version2) || this.providedModules.contains(moduleName);
    }

    protected void addSpec(EntrySpec spec) {
        this.debug("adding.entry", spec.name);
        this.entrySpecs.add(spec);
    }

    protected void debug(String key, Object ... args) {
        if (this.verbose != null && !this.verbose.equals("loader")) {
            try {
                this.append("Debug: ").append(CeylonWarMessages.msg(key, args)).newline();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean addResources(List<EntrySpec> entries) throws MalformedURLException {
        File root;
        if (this.resourceRoot == null) {
            File defaultRoot = this.applyCwd(new File("web-content"));
            if (!defaultRoot.exists()) {
                return false;
            }
            root = defaultRoot;
        } else {
            root = this.applyCwd(new File(this.resourceRoot));
        }
        if (!root.exists()) {
            throw new ToolUsageError(CeylonWarMessages.msg("resourceRoot.missing", root.getAbsolutePath()));
        }
        if (!root.isDirectory()) {
            throw new ToolUsageError(CeylonWarMessages.msg("resourceRoot.nondir", root.getAbsolutePath()));
        }
        this.debug("adding.resources", root.getAbsolutePath());
        return this.addResources(root, "", entries);
    }

    protected boolean addResources(File root, String prefix, List<EntrySpec> entries) throws MalformedURLException {
        boolean webXmlAdded = false;
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                webXmlAdded = webXmlAdded || this.addResources(f, prefix + f.getName() + "/", entries);
                continue;
            }
            this.addSpec(new URLEntrySpec(f.toURI().toURL(), prefix + f.getName()));
            if (!f.getName().equals("web.xml") || !prefix.equals("WEB-INF/")) continue;
            this.debug("found.webxml", new Object[0]);
            webXmlAdded = true;
        }
        return webXmlAdded;
    }

    protected void addLibEntries(final List<ArtifactResult> staticMetamodelEntries) throws MalformedURLException {
        final ArrayList libs = new ArrayList();
        this.loader.visitModules(new ModuleGraph.Visitor(){

            @Override
            public void visit(ModuleGraph.Module module) {
                if (module.artifact != null) {
                    File artifact = module.artifact.artifact();
                    try {
                        if (artifact != null) {
                            staticMetamodelEntries.add(module.artifact);
                            if (CeylonWarTool.this.isProvided(module.name, module.version)) {
                                return;
                            }
                            String moduleName = module.name;
                            String version2 = module.version;
                            String versionSuffix = version2 != null && !version2.isEmpty() ? "-" + version2 : "";
                            String name = ModuleUtil.moduleName(moduleName).replace(":", ".") + versionSuffix + ".jar";
                            if (name.contains("/") || name.contains("\\") || name.length() == 0) {
                                throw new ToolUsageError(CeylonWarMessages.msg("module.name.illegal", name));
                            }
                            CeylonWarTool.this.addSpec(new URLEntrySpec(artifact.toURI().toURL(), "WEB-INF/lib/" + name));
                            libs.add(name);
                        }
                    }
                    catch (IOException x) {
                        throw new RuntimeException(x);
                    }
                }
            }
        });
        StringBuffer libList = new StringBuffer();
        for (String lib : libs) {
            libList.append(lib).append("\n");
        }
        this.addSpec(new StringEntrySpec(libList.toString(), "META-INF/libs.txt"));
    }

    protected void writeJarFile(File jarFile, List<ArtifactResult> staticMetamodelEntries) throws IOException {
        try (JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));){
            for (EntrySpec entry : this.entrySpecs) {
                entry.write(out);
            }
            if (this.staticMetamodel) {
                HashSet<String> added = new HashSet<String>();
                JvmBackendUtil.writeStaticMetamodel(out, added, staticMetamodelEntries, this.jdkProvider, new HashSet<String>(this.providedModules));
            }
        }
    }

    class PropertiesEntrySpec
    extends EntrySpec {
        private final Properties properties;

        PropertiesEntrySpec(Properties properties, String name) {
            super(name);
            this.properties = properties;
        }

        @Override
        void write(JarOutputStream out) throws IOException {
            out.putNextEntry(new ZipEntry(this.name));
            this.properties.store(out, "");
        }

        @Override
        InputStream openStream() throws IOException {
            return null;
        }
    }

    class StringEntrySpec
    extends EntrySpec {
        private final String content;

        StringEntrySpec(String content, String name) {
            super(name);
            this.content = content;
        }

        @Override
        InputStream openStream() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes());
        }
    }

    class URLEntrySpec
    extends EntrySpec {
        private final URL url;

        URLEntrySpec(URL url, String name) {
            super(name);
            this.url = url;
        }

        @Override
        InputStream openStream() throws IOException {
            return this.url.openStream();
        }
    }

    abstract class EntrySpec {
        protected final String name;

        EntrySpec(String name) {
            this.name = name;
        }

        void write(JarOutputStream out) throws IOException {
            out.putNextEntry(new ZipEntry(this.name));
            IOUtils.copyStream(this.openStream(), out, true, false);
        }

        abstract InputStream openStream() throws IOException;
    }
}

