/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.checkerframework.checker.signedness.qual.Unsigned;

public final class SignednessUtil {
    private SignednessUtil() {
        throw new Error("Do not instantiate");
    }

    public static @Unsigned int getUnsignedInt(ByteBuffer b) {
        return b.getInt();
    }

    public static @Unsigned short getUnsignedShort(ByteBuffer b) {
        return b.getShort();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b) {
        return b.get();
    }

    public static void getUnsigned(ByteBuffer b, @Unsigned byte[] bs) {
        b.get(bs);
    }

    public static int compareUnsigned(@Unsigned long x, @Unsigned long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static int compareUnsigned(@Unsigned int x, @Unsigned int y) {
        return Integer.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    public static int compareUnsigned(@Unsigned short x, @Unsigned short y) {
        return SignednessUtil.compareUnsigned(SignednessUtil.toUnsignedInt(x), SignednessUtil.toUnsignedInt(y));
    }

    public static int compareUnsigned(@Unsigned byte x, @Unsigned byte y) {
        return SignednessUtil.compareUnsigned(SignednessUtil.toUnsignedInt(x), SignednessUtil.toUnsignedInt(y));
    }

    public static String toUnsignedString(@Unsigned long l) {
        return SignednessUtil.toUnsignedBigInteger(l).toString();
    }

    public static String toUnsignedString(@Unsigned long l, int radix) {
        return SignednessUtil.toUnsignedBigInteger(l).toString(radix);
    }

    public static String toUnsignedString(@Unsigned int i) {
        return Long.toString(SignednessUtil.toUnsignedLong(i));
    }

    public static String toUnsignedString(@Unsigned int i, int radix) {
        return Long.toString(SignednessUtil.toUnsignedLong(i), radix);
    }

    public static String toUnsignedString(@Unsigned short s2) {
        return Long.toString(SignednessUtil.toUnsignedLong(s2));
    }

    public static String toUnsignedString(@Unsigned short s2, int radix) {
        return Long.toString(SignednessUtil.toUnsignedLong(s2), radix);
    }

    public static String toUnsignedString(@Unsigned byte b) {
        return Long.toString(SignednessUtil.toUnsignedLong(b));
    }

    public static String toUnsignedString(@Unsigned byte b, int radix) {
        return Long.toString(SignednessUtil.toUnsignedLong(b), radix);
    }

    private static @Unsigned BigInteger toUnsignedBigInteger(@Unsigned long l) {
        if (l >= 0L) {
            return BigInteger.valueOf(l);
        }
        int upper = (int)(l >>> 32);
        int lower = (int)l;
        return BigInteger.valueOf(SignednessUtil.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(SignednessUtil.toUnsignedLong(lower)));
    }

    public static @Unsigned long toUnsignedLong(@Unsigned int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static @Unsigned long toUnsignedLong(@Unsigned short s2) {
        return (long)s2 & 0xFFFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned short s2) {
        return s2 & 0xFFFF;
    }

    public static @Unsigned long toUnsignedLong(@Unsigned byte b) {
        return (long)b & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned byte b) {
        return b & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned byte b) {
        return (short)(b & 0xFF);
    }
}

