/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.chromattic.api.BuilderException;
import org.chromattic.api.Chromattic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChromatticBuilder {
    private static final Logger log = Logger.getLogger(ChromatticBuilder.class.getName());
    public static final Option<Boolean> USE_SYSTEM_PROPERTIES = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.use_system_properties", "use system properties");
    public static final Option<String> INSTRUMENTOR_CLASSNAME = new Option(Option.Type.STRING, "org.chromattic.api.Option.instrumentor.classname", "intrumentor");
    public static final Option<String> SESSION_LIFECYCLE_CLASSNAME = new Option(Option.Type.STRING, "org.chromattic.api.Option.session_lifecycle.classname", "session life cycle");
    public static final Option<String> OBJECT_FORMATTER_CLASSNAME = new Option(Option.Type.STRING, "org.chromattic.api.Option.object_formatter.classname", "object formatter");
    public static final Option<Boolean> PROPERTY_CACHE_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.property.cache.enabled", "property cache enabled");
    public static final Option<Boolean> PROPERTY_READ_AHEAD_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.property.read_ahead.enabled", "property read ahead enabled");
    public static final Option<Boolean> JCR_OPTIMIZE_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.optimize.jcr.enabled", "jcr optmisation enabled");
    public static final Option<Boolean> JCR_OPTIMIZE_HAS_PROPERTY_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.optimize.jcr.has_property.enabled", "jcr has property optimization enabled");
    public static final Option<Boolean> JCR_OPTIMIZE_HAS_NODE_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.optimize.jcr.has_node.enabled", "jcr has node optimization enabled");
    public static final Option<String> ROOT_NODE_PATH = new Option(Option.Type.STRING, "org.chromattic.api.Option.root_node.path", "the root node path value");
    public static final Option<Boolean> CREATE_ROOT_NODE = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.root_node.create", "creates the chromattic root node when it does not exist");
    public static final Option<Boolean> LAZY_CREATE_ROOT_NODE = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.root_node.lazy_create", "when root node is created it is done in a lazy manner");
    public static final Option<String> ROOT_NODE_TYPE = new Option(Option.Type.STRING, "org.chromattic.api.Option.root_node.root_node_type", "the root node type when it is created by Chromattic");
    private final Set<Class<?>> classes;
    private final Configuration config;
    private boolean initialized = false;
    private final Object lock = new Object();

    public static ChromatticBuilder create() {
        ServiceLoader<ChromatticBuilder> loader = ServiceLoader.load(ChromatticBuilder.class);
        Iterator<ChromatticBuilder> i = loader.iterator();
        ServiceConfigurationError throwable = null;
        while (i.hasNext()) {
            try {
                ChromatticBuilder builder = i.next();
                log.log(Level.FINER, "Found ChromatticBuilder implementation " + builder.getClass().getName());
                return builder;
            }
            catch (ServiceConfigurationError error) {
                if (throwable == null) {
                    throwable = error;
                }
                log.log(Level.FINER, "Could not load ChromatticBuilder implementation, will use next provider", error);
            }
        }
        throw new BuilderException("Could not instanciate builder", throwable);
    }

    public ChromatticBuilder() {
        this.config = this.createDefaultConfiguration();
        this.classes = new HashSet();
    }

    protected Configuration createDefaultConfiguration() {
        ServiceLoader<Configuration.Factory> loader = ServiceLoader.load(Configuration.Factory.class);
        Iterator<Configuration.Factory> i = loader.iterator();
        while (i.hasNext()) {
            try {
                Configuration.Factory builder = i.next();
                log.log(Level.FINER, "Found ChromatticBuilder implementation " + builder.getClass().getName());
                return builder.create();
            }
            catch (ServiceConfigurationError ignore) {
                log.log(Level.FINER, "Could not load ChromatticBuilder implementation, will use next provider", ignore);
            }
        }
        throw new BuilderException("Could not instanciate configuration factory");
    }

    public final Configuration getConfiguration() {
        return this.config;
    }

    public void add(Class<?> clazz) throws NullPointerException, IllegalStateException {
        this.add(clazz, new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class<?> first, Class<?> ... other) throws NullPointerException, IllegalStateException {
        if (first == null) {
            throw new NullPointerException();
        }
        if (other == null) {
            throw new NullPointerException();
        }
        HashSet toAdd = new HashSet(1 + other.length);
        toAdd.add(first);
        for (Class<?> clazz : other) {
            if (clazz == null) {
                throw new IllegalArgumentException("No array containing a null class accepted");
            }
            toAdd.add(clazz);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                throw new IllegalStateException("Cannot add a class to an initialized builder");
            }
            this.classes.addAll(toAdd);
        }
    }

    public final Chromattic build() throws BuilderException {
        return this.build(this.config);
    }

    public final Chromattic build(Configuration config) throws BuilderException {
        this.init();
        config = new Configuration(config);
        return this.boot(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean init() throws BuilderException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.init(this.classes);
                this.initialized = true;
                return true;
            }
            return false;
        }
    }

    protected abstract void init(Set<Class<?>> var1) throws BuilderException;

    protected abstract Chromattic boot(Configuration var1) throws BuilderException;

    public <D> void setOptionValue(Option<D> option, D value) throws NullPointerException {
        this.config.setOptionValue(option, value, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Configuration {
        protected final Map<String, Option.Instance<?>> entries = new HashMap();

        public Configuration() {
        }

        public Configuration(Configuration that) {
            if (that == null) {
                throw new NullPointerException("No null configuration accepted");
            }
            this.entries.putAll(that.entries);
        }

        public Option.Instance<?> getOptionInstance(String name) throws NullPointerException {
            if (name == null) {
                throw new NullPointerException();
            }
            return this.entries.get(name);
        }

        public <D> Option.Instance<D> getOptionInstance(Option<D> option) throws NullPointerException {
            if (option == null) {
                throw new NullPointerException();
            }
            Option.Instance<?> instance = this.entries.get(option.getName());
            return instance;
        }

        public <D> D getOptionValue(Option<D> option) throws NullPointerException {
            Option.Instance<D> instance = this.getOptionInstance(option);
            return (D)(instance != null ? ((Option.Instance)instance).value : null);
        }

        public <D> boolean setOptionValue(Option<D> option, D value, boolean overwrite) throws NullPointerException {
            if (option == null) {
                throw new NullPointerException("No null option");
            }
            if (value == null) {
                throw new NullPointerException("No null value");
            }
            if (overwrite || this.entries.get(option.getName()) == null) {
                Option.Instance instance = new Option.Instance(option, value);
                this.entries.put(option.getName(), instance);
                return true;
            }
            return false;
        }

        public static abstract class Factory {
            public abstract Configuration create();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Option<D> {
        private final String name;
        private final String displayName;
        private final Type<D> type;

        private Option(Type<D> type, String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
        }

        public Type<D> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Instance<D> getInstance(String value) {
            D t = this.type.parse(value);
            return t != null ? new Instance(this, t) : null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Instance<D> {
            private final Option<D> option;
            private final D value;

            private Instance(Option<D> option, D value) {
                if (option == null) {
                    throw new NullPointerException("No null option accepted");
                }
                if (value == null) {
                    throw new NullPointerException("No null option value accepted");
                }
                this.option = option;
                this.value = value;
            }

            public Option<D> getOption() {
                return this.option;
            }

            public D getValue() {
                return this.value;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Instance) {
                    Instance that = (Instance)obj;
                    return ((Option)this.option).name.equals(((Option)that.option).name);
                }
                return false;
            }

            public int hashCode() {
                return ((Option)this.option).name.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Type<D> {
            public static final Type<String> STRING = new Type<String>(String.class){

                @Override
                public String doParse(String value) {
                    return value;
                }
            };
            public static final Type<Boolean> BOOLEAN = new Type<Boolean>(Boolean.class){

                @Override
                public Boolean doParse(String value) {
                    return Boolean.valueOf(value);
                }
            };
            private final Class<D> javaType;

            private Type(Class<D> javaType) {
                this.javaType = javaType;
            }

            public final D parse(String value) {
                if (value == null) {
                    throw new NullPointerException("Cannot parse null value");
                }
                return this.doParse(value);
            }

            protected abstract D doParse(String var1);
        }
    }
}

