/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.chromattic.apt.TypeHierarchyVisitor;
import org.chromattic.spi.instrument.MethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker {
    private final Method method;

    public static Invoker getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        MethodFinder visitor = new MethodFinder(methodName, parameterTypes);
        visitor.accept(clazz);
        if (visitor.method == null) {
            throw new AssertionError((Object)("Could not find method " + methodName));
        }
        return new Invoker(visitor.method);
    }

    public Invoker(Method method) {
        this.method = method;
    }

    public Object invoke(MethodHandler methodInvoker, Object obj, Object ... args) {
        try {
            return methodInvoker.invoke(obj, this.method, args);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    private static class MethodFinder
    extends TypeHierarchyVisitor {
        private final String methodName;
        private final Class[] parameterTypes;
        private Method method;

        private MethodFinder(String methodName, Class[] parameterTypes) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        protected boolean enter(Class type) {
            try {
                this.method = type.getDeclaredMethod(this.methodName, this.parameterTypes);
                return false;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }
    }
}

