/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.collection.delta;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.chromattic.common.collection.delta.DeltaList;
import org.chromattic.common.collection.delta.InsertionSegment;
import org.chromattic.common.collection.delta.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPlaceSegment<E>
extends Segment<E> {
    final DeltaList<E> owner;
    private Segment<E> previous;
    private Segment<E> next;
    int listIndex;
    int listSize;

    public InPlaceSegment(DeltaList<E> owner) {
        this.owner = owner;
    }

    @Override
    Segment<E> getNext() {
        return this.next;
    }

    @Override
    void setNext(Segment<E> next) {
        this.next = next;
    }

    @Override
    Segment<E> getPrevious() {
        return this.previous;
    }

    @Override
    void setPrevious(Segment<E> previous) {
        this.previous = previous;
    }

    @Override
    protected E localGet(int index) {
        return this.owner.list.get(this.listIndex + index);
    }

    @Override
    protected int localSize() {
        return this.listSize;
    }

    @Override
    protected boolean localCanAdd(int index) {
        return index < this.listSize;
    }

    @Override
    protected void localAdd(int index, E element) {
        InsertionSegment is = new InsertionSegment();
        is.insertions.add(element);
        InPlaceSegment<E> ips = new InPlaceSegment<E>(this.owner);
        ips.listIndex = this.listIndex + index;
        ips.listSize = this.listSize - index;
        this.listSize = index;
        this.addAfter(is).addAfter(ips);
    }

    @Override
    protected E localRemove(int index) {
        if (index == 0) {
            Object removed = this.owner.list.get(this.listIndex);
            ++this.listIndex;
            --this.listSize;
            return removed;
        }
        if (index == this.listSize - 1) {
            return this.owner.list.get(this.listIndex + --this.listSize);
        }
        InPlaceSegment<E> ips = new InPlaceSegment<E>(this.owner);
        ips.listIndex = this.listIndex + index + 1;
        ips.listSize = this.listSize - index - 1;
        this.listSize = index;
        this.addAfter(ips);
        return this.owner.list.get(index);
    }

    @Override
    public Iterator<E> localIterator() {
        return new Iterator<E>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < InPlaceSegment.this.listSize;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return InPlaceSegment.this.owner.list.get(InPlaceSegment.this.listIndex + this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void format(StringBuilder builder) {
        builder.append("(");
        int count = 0;
        for (Object e : this.owner.list.subList(this.listIndex, this.listIndex + this.listSize)) {
            if (count > 0) {
                builder.append(",");
            }
            builder.append(e);
            ++count;
        }
        builder.append(")");
    }
}

