/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.core.mapping.MethodMapping;
import org.chromattic.core.mapping.PropertyMapping;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeTypeMapping {
    protected final ClassTypeInfo objectClass;
    private final Set<PropertyMapping> propertyMappings;
    private final Set<MethodMapping> methodMappings;
    private final NameConflictResolution onDuplicate;
    private Class<? extends ObjectFormatter> formatterClass;

    public NodeTypeMapping(ClassTypeInfo objectClass, Set<PropertyMapping> propertyMappings, Set<MethodMapping> methodMappings, NameConflictResolution onDuplicate, Class<? extends ObjectFormatter> formatterClass) {
        this.objectClass = objectClass;
        this.propertyMappings = Collections.unmodifiableSet(new HashSet<PropertyMapping>(propertyMappings));
        this.methodMappings = Collections.unmodifiableSet(new HashSet<MethodMapping>(methodMappings));
        this.onDuplicate = onDuplicate;
        this.formatterClass = formatterClass;
    }

    public ClassTypeInfo getObjectClass() {
        return this.objectClass;
    }

    public Class<? extends ObjectFormatter> getFormatterClass() {
        return this.formatterClass;
    }

    public Set<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Set<MethodMapping> getMethodMappings() {
        return this.methodMappings;
    }

    public NameConflictResolution getOnDuplicate() {
        return this.onDuplicate;
    }

    public int hashCode() {
        return this.objectClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeTypeMapping) {
            NodeTypeMapping that = (NodeTypeMapping)obj;
            return this.objectClass.equals(that.objectClass);
        }
        return false;
    }
}

