/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.core.Domain;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;
import org.chromattic.core.EventBroadcaster;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.spi.instrument.MethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomainSession {
    protected final EventBroadcaster broadcaster;
    final Domain domain;
    protected final SessionWrapper sessionWrapper;

    public DomainSession(Domain domain, SessionWrapper sessionWrapper) {
        this.domain = domain;
        this.broadcaster = new EventBroadcaster();
        this.sessionWrapper = sessionWrapper;
    }

    protected abstract void _setName(EntityContext var1, String var2) throws RepositoryException;

    protected abstract EntityContext _persist(EntityContext var1, String var2) throws RepositoryException;

    protected abstract EntityContext _persist(EntityContext var1, String var2, EntityContext var3) throws RepositoryException;

    protected abstract <O> O _create(Class<O> var1, String var2) throws NullPointerException, IllegalArgumentException, RepositoryException;

    protected abstract <E> E _findById(Class<E> var1, String var2) throws RepositoryException;

    protected abstract <E> E _findByNode(Class<E> var1, Node var2) throws RepositoryException;

    protected abstract void _save() throws RepositoryException;

    protected abstract void _remove(EntityContext var1) throws RepositoryException;

    protected abstract EntityContext _getReferenced(EntityContext var1, String var2, LinkType var3) throws RepositoryException;

    protected abstract boolean _setReferenced(EntityContext var1, String var2, EntityContext var3, LinkType var4) throws RepositoryException;

    protected abstract <T> Iterator<T> _getReferents(EntityContext var1, String var2, Class<T> var3, LinkType var4) throws RepositoryException;

    protected abstract void _removeChild(EntityContext var1, String var2) throws RepositoryException;

    protected abstract EntityContext _getChild(EntityContext var1, String var2) throws RepositoryException;

    protected abstract <T> Iterator<T> _getChildren(EntityContext var1, Class<T> var2) throws RepositoryException;

    protected abstract EntityContext _getParent(EntityContext var1) throws RepositoryException;

    protected abstract <E> E _findByPath(EntityContext var1, Class<E> var2, String var3) throws RepositoryException;

    protected abstract void _orderBefore(EntityContext var1, EntityContext var2, EntityContext var3) throws RepositoryException;

    protected abstract Node _getRoot() throws RepositoryException;

    protected abstract void _move(EntityContext var1, EntityContext var2) throws RepositoryException;

    protected abstract void _addMixin(EntityContext var1, EmbeddedContext var2) throws RepositoryException;

    protected abstract EmbeddedContext _getEmbedded(EntityContext var1, Class<?> var2) throws RepositoryException;

    protected abstract String _getName(EntityContext var1) throws RepositoryException;

    protected abstract void _close() throws RepositoryException;

    public Domain getDomain() {
        return this.domain;
    }

    public Session getJCRSession() {
        return this.sessionWrapper.getSession();
    }

    public <O> QueryBuilder<O> createQueryBuilder(Class<O> fromClass) throws ChromatticException {
        return this.domain.queryManager.createQueryBuilder(this, fromClass);
    }

    public void addEventListener(EventListener listener) {
        this.broadcaster.addLifeCycleListener(listener);
    }

    public void close() {
        try {
            this._close();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public EmbeddedContext getEmbedded(EntityContext ctx, Class<?> embeddedClass) throws UndeclaredRepositoryException {
        try {
            return this._getEmbedded(ctx, embeddedClass);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public void save() throws UndeclaredRepositoryException {
        try {
            this._save();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public <E> E findById(Class<E> clazz, String id) throws UndeclaredRepositoryException {
        try {
            return this._findById(clazz, id);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public <E> E findByPath(EntityContext ctx, Class<E> clazz, String relPath) throws UndeclaredRepositoryException {
        try {
            return this._findByPath(ctx, clazz, relPath);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public <E> E findByNode(Class<E> clazz, Node node) throws UndeclaredRepositoryException {
        try {
            return this._findByNode(clazz, node);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public EntityContext persist(EntityContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            return this._persist(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public <O> O create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, UndeclaredRepositoryException {
        try {
            return this._create(clazz, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public String getName(EntityContext ctx) throws UndeclaredRepositoryException {
        try {
            return this._getName(ctx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public void addMixin(EntityContext ctx, EmbeddedContext mixinCtx) throws ChromatticException {
        try {
            this._addMixin(ctx, mixinCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void setName(EntityContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            this._setName(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void orderBefore(EntityContext parentCtx, EntityContext srcCtx, EntityContext dstCtx) {
        try {
            this._orderBefore(parentCtx, srcCtx, dstCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public void move(EntityContext srcCtx, EntityContext dstCtx) throws UndeclaredRepositoryException {
        try {
            this._move(srcCtx, dstCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void remove(EntityContext context) throws UndeclaredRepositoryException {
        try {
            this._remove(context);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final EntityContext getReferenced(EntityContext referentCtx, String name, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._getReferenced(referentCtx, name, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final boolean setReferenced(EntityContext referentCtx, String name, EntityContext referencedCtx, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._setReferenced(referentCtx, name, referencedCtx, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void removeChild(EntityContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            this._removeChild(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final EntityContext getChild(EntityContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            return this._getChild(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <T> Iterator<T> getChildren(EntityContext ctx, Class<T> filterClass) throws UndeclaredRepositoryException {
        try {
            return this._getChildren(ctx, filterClass);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final EntityContext getParent(EntityContext ctx) throws UndeclaredRepositoryException {
        try {
            return this._getParent(ctx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <T> Iterator<T> getReferents(EntityContext referencedCtx, String name, Class<T> filterClass, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._getReferents(referencedCtx, name, filterClass, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final EntityContext unwrapEntity(Object o) throws NullPointerException, IllegalArgumentException {
        return this.unwrap(o, EntityContext.class);
    }

    public final EmbeddedContext unwrapMixin(Object o) {
        return this.unwrap(o, EmbeddedContext.class);
    }

    private <T> T unwrap(Object o, Class<T> expectedClass) {
        if (o == null) {
            throw new NullPointerException("Cannot unwrap null object");
        }
        if (expectedClass == null) {
            throw new NullPointerException();
        }
        MethodHandler handler = this.domain.getInstrumentor().getInvoker(o);
        if (handler == null) {
            throw new IllegalArgumentException("The object with class " + o.getClass().getName() + " is not instrumented");
        }
        if (expectedClass.isInstance(handler)) {
            return expectedClass.cast(handler);
        }
        throw new AssertionError((Object)("The proxy " + o + " handler is not of the expected type"));
    }

    public final EntityContext persist(EntityContext parentCtx, EntityContext childCtx, String name) throws UndeclaredRepositoryException {
        try {
            return this._persist(parentCtx, name, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Node getRoot() {
        try {
            return this._getRoot();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public SessionWrapper getSessionWrapper() {
        return this.sessionWrapper;
    }
}

