/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.chromattic.core.MethodInvoker;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.bean.PropertyInfo;
import org.chromattic.core.jcr.NodeDef;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.instrument.MethodHandler;
import org.chromattic.spi.instrument.ProxyFactory;
import org.reflext.api.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapper
implements MethodInvoker {
    private final Class<?> objectClass;
    private final NodeDef nodeDef;
    final Set<MethodMapper> methodMappers;
    final Set<PropertyMapper> propertyMappers;
    private final ProxyFactory factory;
    private final Map<Method, MethodInvoker> dispatchers;

    public TypeMapper(Class<?> objectClass, Set<PropertyMapper> propertyMappers, Set<MethodMapper> methodMappers, NodeDef nodeDef, Instrumentor instrumentor) {
        HashMap<Method, MethodInvoker> dispatchers = new HashMap<Method, MethodInvoker>();
        for (PropertyMapper propertyMapper : propertyMappers) {
            MethodInfo setter;
            Object info = propertyMapper.getInfo();
            MethodInfo getter = ((PropertyInfo)info).getGetter();
            if (getter != null) {
                dispatchers.put((Method)getter.getMethod(), propertyMapper);
            }
            if ((setter = ((PropertyInfo)info).getSetter()) == null) continue;
            dispatchers.put((Method)setter.getMethod(), propertyMapper);
        }
        for (MethodMapper methodMapper : methodMappers) {
            dispatchers.put(methodMapper.getMethod(), methodMapper);
        }
        this.dispatchers = dispatchers;
        this.objectClass = objectClass;
        this.methodMappers = methodMappers;
        this.nodeDef = nodeDef;
        this.propertyMappers = propertyMappers;
        this.factory = instrumentor.getProxyClass(objectClass);
    }

    @Override
    public Object invoke(ObjectContext ctx, Method method, Object[] args) throws Throwable {
        int i;
        MethodInvoker invoker = this.dispatchers.get(method);
        if (invoker != null) {
            return invoker.invoke(ctx, method, args);
        }
        StringBuilder msg = new StringBuilder("Cannot invoke method ").append(method.getName()).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                msg.append(',');
            }
            msg.append(parameterTypes[i].getName());
        }
        msg.append(") with arguments (");
        for (i = 0; i < args.length; ++i) {
            if (i > 0) {
                msg.append(',');
            }
            msg.append(String.valueOf(args[i]));
        }
        msg.append(")");
        throw new AssertionError(msg);
    }

    public Object createObject(ObjectContext context) {
        return this.factory.createProxy((MethodHandler)context);
    }

    public Set<MethodMapper> getMethodMappers() {
        return this.methodMappers;
    }

    public Set<PropertyMapper> getPropertyMappers() {
        return this.propertyMappers;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public NodeDef getNodeDef() {
        return this.nodeDef;
    }

    public String toString() {
        return "TypeMapper[class=" + this.objectClass + ",nodeType=" + this.nodeDef + "]";
    }
}

