/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.lang.reflect.Method;
import org.chromattic.core.MethodInvoker;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.TypeMapper;
import org.reflext.api.ClassTypeInfo;

public class MethodMapper
implements MethodInvoker {
    TypeMapper mapper;
    private final Method method;

    public MethodMapper(Method method) {
        this.method = method;
    }

    public Object invoke(ObjectContext context, Object[] args) throws Throwable {
        throw new UnsupportedOperationException();
    }

    public Method getMethod() {
        return this.method;
    }

    public Object invoke(ObjectContext ctx, Method method, Object[] args) throws Throwable {
        return this.invoke(ctx, args);
    }

    public String toString() {
        return "MethodMapper[" + this.method.getDeclaringClass().getName() + "#" + this.method.getName() + "]";
    }

    public static class Destroy
    extends MethodMapper {
        public Destroy(Method method) {
            super(method);
        }

        public Object invoke(ObjectContext context, Object[] args) throws Throwable {
            context.remove();
            return null;
        }
    }

    public static class FindById
    extends MethodMapper {
        private final ClassTypeInfo type;
        private final Class<?> typeClass;

        public FindById(Method method, ClassTypeInfo type) throws ClassNotFoundException {
            super(method);
            this.type = type;
            this.typeClass = Thread.currentThread().getContextClassLoader().loadClass(type.getName());
        }

        public Object invoke(ObjectContext context, Object[] args) throws Throwable {
            String id = (String)args[0];
            Object o = context.getSession().findById(Object.class, id);
            if (this.typeClass.isInstance(o)) {
                return o;
            }
            return null;
        }
    }

    public static class Create
    extends MethodMapper {
        TypeMapper type;

        public Create(Method method) {
            super(method);
        }

        public Object invoke(ObjectContext context, Object[] args) {
            String name = null;
            if (args.length == 1 && args[0] != null && args[0] instanceof String) {
                name = (String)args[0];
            }
            if (name == null) {
                return context.getSession().create(this.type.getObjectClass());
            }
            return context.getSession().create(this.type.getObjectClass(), name);
        }
    }
}

