/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.query;

import org.chromattic.api.query.ObjectQuery;
import org.chromattic.api.query.ObjectQueryBuilder;
import org.chromattic.api.query.ObjectQueryResult;
import org.chromattic.core.Domain;
import org.chromattic.core.mapper.TypeMapper;
import org.chromattic.core.query.QueryManager;

public class ObjectQueryBuilderImpl
implements ObjectQueryBuilder {
    private Class<?> fromClass;
    private String where;
    private TypeMapper mapper;
    private QueryManager manager;
    private Domain domain;

    public ObjectQueryBuilderImpl(Domain domain, QueryManager manager) {
        this.manager = manager;
        this.fromClass = null;
        this.where = null;
        this.domain = domain;
    }

    public ObjectQueryBuilder from(Class fromClass) {
        if (fromClass == null) {
            throw new NullPointerException();
        }
        if (this.fromClass != null) {
            throw new IllegalStateException();
        }
        TypeMapper mapper = this.domain.getTypeMapper(fromClass);
        if (mapper == null) {
            throw new IllegalArgumentException("Class " + fromClass.getName() + " is not mapped");
        }
        this.mapper = mapper;
        this.fromClass = fromClass;
        return this;
    }

    public ObjectQueryBuilder where(String whereStatement) {
        if (whereStatement == null) {
            throw new NullPointerException();
        }
        this.where = whereStatement;
        return this;
    }

    public ObjectQueryBuilder orderBy(String orderBy) throws NullPointerException {
        throw new UnsupportedOperationException("todo");
    }

    public ObjectQuery get() {
        if (this.fromClass == null) {
            throw new IllegalStateException();
        }
        StringBuffer sb = new StringBuffer("SELECT * FROM ");
        sb.append(this.mapper.getNodeDef().getPrimaryNodeTypeName());
        if (this.where != null) {
            sb.append(" WHERE ");
            sb.append(this.where);
        }
        return this.manager.getObjectQuery(this.mapper.getObjectClass(), sb.toString());
    }

    public ObjectQueryResult iterator() {
        ObjectQuery query = this.get();
        return query.iterator();
    }
}

