/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.ArrayList;
import java.util.List;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.event.LifeCycleListener;
import org.chromattic.api.event.StateChangeListener;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.core.PersistentEntityContextState;

public class EventBroadcaster
implements EventListener {
    private List<LifeCycleListener> lifeCycleListeners = null;
    private List<StateChangeListener> stateChangeListeners;

    public final void addLifeCycleListener(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (listener instanceof LifeCycleListener) {
            if (this.lifeCycleListeners == null) {
                this.lifeCycleListeners = new ArrayList<LifeCycleListener>();
            }
            this.lifeCycleListeners.add((LifeCycleListener)listener);
        }
        if (listener instanceof StateChangeListener) {
            if (this.stateChangeListeners == null) {
                this.stateChangeListeners = new ArrayList<StateChangeListener>();
            }
            this.stateChangeListeners.add((StateChangeListener)listener);
        }
    }

    public boolean hasLifeCycleListeners() {
        return this.lifeCycleListeners != null;
    }

    public boolean hasStateChangeListeners() {
        return this.stateChangeListeners != null;
    }

    public void created(Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.created(o);
            }
            catch (Exception ignore) {}
        }
    }

    public void loaded(PersistentEntityContextState state, Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        String id = state.getId();
        String path = state.getPath();
        String name = state.getName();
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.loaded(id, path, name, o);
            }
            catch (Exception ignore) {}
        }
    }

    public void added(PersistentEntityContextState state, Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        String id = state.getId();
        String path = state.getPath();
        String name = state.getName();
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.added(id, path, name, o);
            }
            catch (Exception ignore) {}
        }
    }

    public void removed(PersistentEntityContextState state, Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        String id = state.getId();
        String path = state.getPath();
        String name = state.getName();
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.removed(id, path, name, o);
            }
            catch (Exception ignore) {}
        }
    }

    public void propertyChanged(Object o, String propertyName, Object propertyValue) {
        if (this.stateChangeListeners == null) {
            return;
        }
        for (StateChangeListener listener : this.stateChangeListeners) {
            try {
                if (propertyValue instanceof CloneableInputStream) {
                    listener.propertyChanged(o, propertyName, (Object)((CloneableInputStream)propertyValue).clone());
                    continue;
                }
                listener.propertyChanged(o, propertyName, propertyValue);
            }
            catch (Exception ignore) {}
        }
    }
}

