/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr.info;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.chromattic.core.jcr.info.MixinsNodeInfo;
import org.chromattic.core.jcr.info.NodeInfo;
import org.chromattic.core.jcr.info.NodeTypeInfo;

public class NodeInfoManager {
    private final Object primaryNodeInfosLock = new Object();
    private volatile Map<String, NodeInfo> primaryNodeInfos = new HashMap<String, NodeInfo>();
    private final Object nodeTypeInfosLock = new Object();
    private volatile Map<String, NodeTypeInfo> nodeTypeInfos = new HashMap<String, NodeTypeInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeInfo getNodeInfo(Node node) throws RepositoryException {
        NodeType primaryNodeType = node.getPrimaryNodeType();
        String primaryNodeTypeName = primaryNodeType.getName();
        NodeType[] mixinNodeTypes = node.getMixinNodeTypes();
        if (mixinNodeTypes.length == 0) {
            NodeInfo nodeInfo = this.primaryNodeInfos.get(primaryNodeTypeName);
            if (nodeInfo == null) {
                Object object = this.primaryNodeInfosLock;
                synchronized (object) {
                    NodeTypeInfo primaryNodeTypeInfo = this.getNodeTypeInfo(primaryNodeType);
                    nodeInfo = new NodeInfo(primaryNodeTypeInfo);
                    HashMap<String, NodeInfo> copy = new HashMap<String, NodeInfo>(this.primaryNodeInfos);
                    copy.put(primaryNodeTypeName, nodeInfo);
                    this.primaryNodeInfos = copy;
                }
            }
            return nodeInfo;
        }
        NodeTypeInfo primaryNodeTypeInfo = this.getNodeTypeInfo(primaryNodeType);
        NodeTypeInfo[] mixinNodeTypeInfos = new NodeTypeInfo[mixinNodeTypes.length];
        for (int i = 0; i < mixinNodeTypes.length; ++i) {
            NodeType mixinNodeType = mixinNodeTypes[i];
            mixinNodeTypeInfos[i] = this.getNodeTypeInfo(mixinNodeType);
        }
        return new MixinsNodeInfo(primaryNodeTypeInfo, mixinNodeTypeInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeTypeInfo getNodeTypeInfo(NodeType nodeType) {
        String nodeTypeName = nodeType.getName();
        NodeTypeInfo nodeTypeInfo = this.nodeTypeInfos.get(nodeTypeName);
        if (nodeTypeInfo == null) {
            Object object = this.nodeTypeInfosLock;
            synchronized (object) {
                nodeTypeInfo = new NodeTypeInfo(nodeType);
                HashMap<String, NodeTypeInfo> copy = new HashMap<String, NodeTypeInfo>(this.nodeTypeInfos);
                copy.put(nodeTypeName, nodeTypeInfo);
                this.nodeTypeInfos = copy;
            }
        }
        return nodeTypeInfo;
    }
}

