/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.query;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.query.ObjectQuery;
import org.chromattic.api.query.ObjectQueryResult;
import org.chromattic.core.DomainSession;
import org.chromattic.core.query.ObjectQueryResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectQueryImpl<O>
implements ObjectQuery<O> {
    private final Query jcrQuery;
    private final DomainSession domainSession;
    private final Class<O> clazz;

    public ObjectQueryImpl(Class<O> clazz, DomainSession domainSession, String jcrStatement) throws RepositoryException {
        Session jcrSession = domainSession.getJCRSession();
        QueryManager queryMgr = jcrSession.getWorkspace().getQueryManager();
        Query jcrQuery = queryMgr.createQuery(jcrStatement, "sql");
        this.clazz = clazz;
        this.domainSession = domainSession;
        this.jcrQuery = jcrQuery;
    }

    public ObjectQueryResult<O> iterator() {
        try {
            QueryResult result = this.jcrQuery.execute();
            NodeIterator iterator = result.getNodes();
            return new ObjectQueryResultImpl<O>(this.domainSession, iterator, this.clazz);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }
}

