/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.core.mapping.MethodMapping;
import org.chromattic.core.mapping.PropertyMapping;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeMapping {
    protected final ClassTypeInfo objectClass;
    private final Set<PropertyMapping> propertyMappings;
    private final Set<MethodMapping> methodMappings;
    private final NameConflictResolution onDuplicate;

    public TypeMapping(ClassTypeInfo objectClass, Set<PropertyMapping> propertyMappings, Set<MethodMapping> methodMappings, NameConflictResolution onDuplicate) {
        this.objectClass = objectClass;
        this.propertyMappings = Collections.unmodifiableSet(new HashSet<PropertyMapping>(propertyMappings));
        this.methodMappings = Collections.unmodifiableSet(new HashSet<MethodMapping>(methodMappings));
        this.onDuplicate = onDuplicate;
    }

    public ClassTypeInfo getObjectClass() {
        return this.objectClass;
    }

    public Set<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Set<MethodMapping> getMethodMappings() {
        return this.methodMappings;
    }

    public NameConflictResolution getOnDuplicate() {
        return this.onDuplicate;
    }

    public int hashCode() {
        return this.objectClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeMapping) {
            TypeMapping that = (TypeMapping)obj;
            return this.objectClass.equals(that.objectClass);
        }
        return false;
    }
}

