/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.bean;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.chromattic.api.BuilderException;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.core.bean.ObjectSimpleType;
import org.chromattic.core.bean.PrimitiveSimpleType;
import org.chromattic.core.bean.SimpleType;
import org.chromattic.core.bean.ValueInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.SimpleTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValueInfo<V>
extends ValueInfo {
    private final SimpleType<V> simpleType;
    private List<V> defaultValue;

    private SimpleValueInfo(ClassTypeInfo typeInfo, SimpleType<V> simpleType, List<V> defaultValue) {
        super(typeInfo);
        if (defaultValue != null) {
            defaultValue = Collections.unmodifiableList(new ArrayList<V>(defaultValue));
        }
        this.simpleType = simpleType;
        this.defaultValue = defaultValue;
    }

    public SimpleType<V> getSimpleType() {
        return this.simpleType;
    }

    public List<V> getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "SimpleValueInfo[simpleType=" + this.simpleType + "]";
    }

    public static SimpleValueInfo<String> createPath(ClassTypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new NullPointerException();
        }
        if (typeInfo.getName().equals(String.class.getName())) {
            return new SimpleValueInfo<String>(typeInfo, ObjectSimpleType.PATH, null);
        }
        throw new IllegalArgumentException("Simple value of type path must have a type of " + String.class.getName());
    }

    public static SimpleValueInfo<?> create(ClassTypeInfo typeInfo, Annotation defaultValue) throws BuilderException {
        if (typeInfo == null) {
            throw new NullPointerException();
        }
        if (typeInfo instanceof SimpleTypeInfo) {
            boolean primitive = ((SimpleTypeInfo)typeInfo).isPrimitive();
            if (!primitive) {
                if (defaultValue != null) {
                    throw new BuilderException("Non primitive property cannot have a default value");
                }
                switch (((SimpleTypeInfo)typeInfo).getLiteralType()) {
                    case BOOLEAN: {
                        return new SimpleValueInfo<Boolean>(typeInfo, ObjectSimpleType.BOOLEAN, null);
                    }
                    case INT: {
                        return new SimpleValueInfo<Integer>(typeInfo, ObjectSimpleType.INT, null);
                    }
                    case LONG: {
                        return new SimpleValueInfo<Long>(typeInfo, ObjectSimpleType.LONG, null);
                    }
                    case FLOAT: {
                        return new SimpleValueInfo<Float>(typeInfo, ObjectSimpleType.FLOAT, null);
                    }
                    case DOUBLE: {
                        return new SimpleValueInfo<Double>(typeInfo, ObjectSimpleType.DOUBLE, null);
                    }
                }
                throw new AssertionError();
            }
            switch (((SimpleTypeInfo)typeInfo).getLiteralType()) {
                case BOOLEAN: {
                    List<Boolean> defaultBoolean = null;
                    if (defaultValue != null) {
                        if (defaultValue instanceof DefaultValue.Boolean) {
                            defaultBoolean = Arrays.asList(((DefaultValue.Boolean)defaultValue).value());
                        } else {
                            throw new BuilderException();
                        }
                    }
                    return new SimpleValueInfo<Boolean>(typeInfo, PrimitiveSimpleType.BOOLEAN, defaultBoolean);
                }
                case INT: {
                    List<Integer> defaultInteger = null;
                    if (defaultValue != null) {
                        if (defaultValue instanceof DefaultValue.Int) {
                            defaultInteger = Arrays.asList(((DefaultValue.Int)defaultValue).value());
                        } else {
                            throw new BuilderException();
                        }
                    }
                    return new SimpleValueInfo<Integer>(typeInfo, PrimitiveSimpleType.INT, defaultInteger);
                }
                case LONG: {
                    List<Long> defaultLong = null;
                    if (defaultValue != null) {
                        if (defaultValue instanceof DefaultValue.Long) {
                            defaultLong = Arrays.asList(((DefaultValue.Long)defaultValue).value());
                        } else {
                            throw new BuilderException();
                        }
                    }
                    return new SimpleValueInfo<Long>(typeInfo, PrimitiveSimpleType.LONG, defaultLong);
                }
                case FLOAT: {
                    List<Float> defaultFloat = null;
                    if (defaultValue != null) {
                        if (defaultValue instanceof DefaultValue.Float) {
                            defaultFloat = Arrays.asList(Float.valueOf(((DefaultValue.Float)defaultValue).value()));
                        } else {
                            throw new BuilderException();
                        }
                    }
                    return new SimpleValueInfo<Float>(typeInfo, PrimitiveSimpleType.FLOAT, defaultFloat);
                }
                case DOUBLE: {
                    List<Double> defaultDouble = null;
                    if (defaultValue != null) {
                        if (defaultValue instanceof DefaultValue.Double) {
                            defaultDouble = Arrays.asList(((DefaultValue.Double)defaultValue).value());
                        } else {
                            throw new BuilderException();
                        }
                    }
                    return new SimpleValueInfo<Double>(typeInfo, PrimitiveSimpleType.DOUBLE, defaultDouble);
                }
            }
            throw new AssertionError();
        }
        if (defaultValue != null) {
            throw new BuilderException("Non primitive property cannot have a default value");
        }
        if (String.class.getName().equals(typeInfo.getName())) {
            return new SimpleValueInfo<String>(typeInfo, ObjectSimpleType.STRING, null);
        }
        if (Date.class.getName().equals(typeInfo.getName())) {
            return new SimpleValueInfo<Date>(typeInfo, ObjectSimpleType.DATE, null);
        }
        if (InputStream.class.getName().equals(typeInfo.getName())) {
            return new SimpleValueInfo<InputStream>(typeInfo, ObjectSimpleType.BINARY, null);
        }
        throw new AssertionError();
    }
}

