/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.chromattic.api.DuplicateNameException;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.Status;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.JCR;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.ChildCollectionIterator;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContext;
import org.chromattic.core.PersistentEntityContextState;
import org.chromattic.core.ReferentCollectionIterator;
import org.chromattic.core.RemovedEntityContextState;
import org.chromattic.core.TransientEntityContextState;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.core.mapper.NodeTypeMapper;
import org.chromattic.core.mapper.TypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainSessionImpl
extends DomainSession {
    final Domain domain;
    private final Map<String, EntityContext> contexts;
    private final Logger log = Logger.getLogger(DomainSession.class);

    public DomainSessionImpl(Domain domain, SessionWrapper sessionWrapper) {
        super(domain, sessionWrapper);
        this.domain = domain;
        this.contexts = new HashMap<String, EntityContext>();
    }

    @Override
    protected String _getName(EntityContext ctx) {
        String name;
        if (ctx == null) {
            throw new NullPointerException();
        }
        if (ctx.getStatus() == Status.PERSISTENT) {
            name = ctx.state.getName();
            Object parent = this.getParent(ctx);
            EntityContext parentCtx = parent != null ? this.unwrap(parent) : null;
            name = this.decodeName(parentCtx, name);
        } else {
            name = ctx.state.getName();
        }
        return name;
    }

    @Override
    protected void _setName(EntityContext ctx, String name) {
        if (ctx == null) {
            throw new NullPointerException();
        }
        ctx.state.setName(name);
    }

    @Override
    protected <O> O _findByPath(EntityContext ctx, Class<O> clazz, String relPath) throws RepositoryException {
        Node origin;
        if (ctx != null) {
            origin = ctx.state.getNode();
        } else {
            origin = this.getRoot();
            this.nodeRead(origin);
        }
        try {
            Node node = origin.getNode(relPath);
            this.nodeRead(node);
            return this.findByNode(clazz, node);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    protected String _persist(EntityContext ctx, String name) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException("No null object context accepted");
        }
        if (name == null) {
            throw new NullPointerException("No relative path specified");
        }
        if (ctx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to persist non transient object " + ctx;
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.log.trace("Setting context {} for insertion", (Object)ctx);
        this.log.trace("Adding node for context {} and node type {}", (Object)ctx, (Object)ctx.mapper);
        return this._persist(this.getRoot(), name, ctx);
    }

    @Override
    protected String _persist(EntityContext srcCtx, String name, EntityContext dstCtx) throws NullPointerException, IllegalArgumentException, IllegalStateException, RepositoryException {
        if (srcCtx == null) {
            String msg = "Cannot insert context " + dstCtx + " as a child of a null context";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (dstCtx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to insert non transient context " + dstCtx + " as child of " + srcCtx;
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
        if (name == null) {
            String msg = "Attempt to insert context " + dstCtx + " with no relative path to " + srcCtx;
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (srcCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to insert context " + dstCtx + " as child of non persistent context " + srcCtx;
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
        Node parentNode = srcCtx.state.getNode();
        return this._persist(parentNode, name, dstCtx);
    }

    private String _persist(Node srcNode, String name, EntityContext dstCtx) throws RepositoryException {
        Node previousNode;
        if (!(dstCtx.mapper instanceof NodeTypeMapper)) {
            throw new IllegalArgumentException("Cannot persist an object mapper to a mixin type " + dstCtx.mapper);
        }
        NodeTypeMapper mapper = (NodeTypeMapper)dstCtx.mapper;
        Object parent = this.findByNode(Object.class, srcNode);
        EntityContext parentCtx = parent != null ? this.unwrap(parent) : null;
        name = this.encodeName(parentCtx, name);
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NodeType parentNodeType = srcNode.getPrimaryNodeType();
        TypeMapper parentTypeMapper = this.domain.getTypeMapper(parentNodeType.getName());
        if (parentTypeMapper != null) {
            onDuplicate = parentTypeMapper.getOnDuplicate();
        }
        if ((previousNode = this.sessionWrapper.getNode(srcNode, name)) != null) {
            this.log.trace("Found existing child with same name {}", (Object)name);
            if (onDuplicate == NameConflictResolution.FAIL) {
                String msg = "Attempt to insert context " + dstCtx + " as an existing child with name " + name + " child of node " + srcNode.getPath();
                this.log.error(msg);
                throw new DuplicateNameException(msg);
            }
            this.log.trace("About to remove same name {} child with id {}", (Object)previousNode.getPath(), (Object)previousNode.getName());
            this.remove(previousNode);
        }
        String primaryNodeTypeName = mapper.getNodeTypeName();
        this.log.trace("Setting context {} for insertion", (Object)dstCtx);
        this.log.trace("Adding node for context {} and node type {} as child of node {}", new Object[]{dstCtx, primaryNodeTypeName, srcNode.getPath()});
        Node dstNode = this.sessionWrapper.addNode(srcNode, name, primaryNodeTypeName, Collections.<String>emptyList());
        this.nodeAdded(dstNode, dstCtx);
        String relatedId = dstNode.getUUID();
        this.log.trace("Added context {} for id {} and path {}", new Object[]{dstCtx, relatedId, dstNode.getPath()});
        return relatedId;
    }

    @Override
    protected void _move(EntityContext srcCtx, EntityContext dstCtx) throws RepositoryException {
        Node previousNode;
        if (srcCtx == null) {
            String msg = "Cannot move null context";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (dstCtx == null) {
            String msg = "Cannot move to null context";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (srcCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to move non persistent context " + srcCtx + " as child of " + dstCtx;
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
        if (dstCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to move child " + srcCtx + " to a non persistent context " + dstCtx;
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
        Node dstNode = dstCtx.state.getNode();
        Node srcNode = srcCtx.state.getNode();
        String name = srcNode.getName();
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NodeType parentNodeType = dstNode.getPrimaryNodeType();
        TypeMapper parentTypeMapper = this.domain.getTypeMapper(parentNodeType.getName());
        if (parentTypeMapper != null) {
            onDuplicate = parentTypeMapper.getOnDuplicate();
        }
        if ((previousNode = this.sessionWrapper.getNode(dstNode, name)) != null) {
            this.log.trace("Found existing child with same name {}", (Object)name);
            if (onDuplicate == NameConflictResolution.FAIL) {
                String msg = "Attempt to move context " + dstCtx + " as an existing child with name " + name + " child of node " + dstNode.getPath();
                this.log.error(msg);
                throw new DuplicateNameException(msg);
            }
            this.log.trace("About to remove same name {} child with id {}", (Object)previousNode.getPath(), (Object)previousNode.getName());
            throw new UnsupportedOperationException("Do that properly");
        }
        this.sessionWrapper.move(srcNode, dstNode);
    }

    @Override
    protected void _orderBefore(EntityContext parentCtx, EntityContext srcCtx, EntityContext dstCtx) throws RepositoryException {
        if (parentCtx == null) {
            throw new NullPointerException();
        }
        if (srcCtx == null) {
            throw new NullPointerException();
        }
        Node parentNode = parentCtx.state.getNode();
        Node srcNode = srcCtx.state.getNode();
        Node dstNode = dstCtx != null ? dstCtx.state.getNode() : null;
        this.sessionWrapper.orderBefore(parentNode, srcNode, dstNode);
    }

    @Override
    protected <O> O _create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        TypeMapper typeMapper = this.domain.getTypeMapper(clazz);
        TransientEntityContextState state = new TransientEntityContextState(this);
        EntityContext ctx = new EntityContext(typeMapper, state);
        if (name != null) {
            ctx.setName(name);
        }
        this.broadcaster.created(ctx.getObject());
        return clazz.cast(ctx.getObject());
    }

    @Override
    protected <O> O _findById(Class<O> clazz, String id) throws RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.contexts.get(id);
        if (ctx == null) {
            try {
                this.log.trace("About to load node with id {} and class {}", (Object)id, (Object)clazz.getName());
                Node node = this.sessionWrapper.getNodeByUUID(id);
                this.nodeRead(node);
                this.log.trace("Loaded node with id {}", (Object)id, (Object)clazz.getName());
                ctx = this.contexts.get(id);
                this.log.trace("Obtained context {} node for id {} and class {}", new Object[]{ctx, id, clazz.getName()});
            }
            catch (ItemNotFoundException e) {
                this.log.trace("Could not find node with id {}", (Object)id, (Object)clazz.getName());
                return null;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        if (ctx == null) {
            return null;
        }
        Object object = ctx.object;
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        String msg = "Could not cast context " + ctx + " with class " + object.getClass().getName() + " to class " + clazz.getName();
        throw new ClassCastException(msg);
    }

    @Override
    protected void _save() throws RepositoryException {
        this.sessionWrapper.save();
    }

    @Override
    protected void _remove(EntityContext context) throws RepositoryException {
        if (context == null) {
            throw new NullPointerException();
        }
        switch (context.state.getStatus()) {
            case TRANSIENT: {
                throw new IllegalStateException("Cannot remove transient node");
            }
            case PERSISTENT: {
                Node node = context.state.getNode();
                this.remove(node);
                break;
            }
            case REMOVED: {
                throw new IllegalStateException("Cannot remove removed node");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void remove(Node node) throws RepositoryException {
        Iterator<String> ids = this.sessionWrapper.remove(node);
        while (ids.hasNext()) {
            String id = ids.next();
            this.nodeRemoved(id);
        }
    }

    @Override
    protected Object _getReferenced(EntityContext referentCtx, String name, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node referent = referentCtx.state.getNode();
        Node referenced = this.sessionWrapper.getReferenced(referent, name, linkType);
        if (referenced != null) {
            return this.findByNode(Object.class, referenced);
        }
        return null;
    }

    @Override
    protected boolean _setReferenced(EntityContext referentCtx, String name, EntityContext referencedCtx, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException("Cannot create a relationship with a non persisted context " + this);
        }
        Node referent = referentCtx.state.getNode();
        if (referencedCtx != null) {
            if (referencedCtx.getStatus() != Status.PERSISTENT) {
                throw new IllegalStateException();
            }
            Node referenced = referencedCtx.state.getNode();
            return referenced != this.sessionWrapper.setReferenced(referent, name, referenced, linkType);
        }
        return null != this.sessionWrapper.setReferenced(referent, name, null, linkType);
    }

    @Override
    protected <T> Iterator<T> _getReferents(EntityContext referencedCtx, String name, Class<T> filterClass, LinkType linkType) throws RepositoryException {
        Node referenced = referencedCtx.state.getNode();
        Iterator<Node> referents = this.sessionWrapper.getReferents(referenced, name, linkType);
        return new ReferentCollectionIterator<T>(this, referents, filterClass, name);
    }

    @Override
    protected void _removeChild(EntityContext ctx, String name) throws RepositoryException {
        name = this.encodeName(ctx, name);
        Node node = ctx.state.getNode();
        Node childNode = this.sessionWrapper.getNode(node, name);
        if (childNode != null) {
            this.remove(childNode);
        }
    }

    @Override
    protected Object _getChild(EntityContext ctx, String name) throws RepositoryException {
        name = this.encodeName(ctx, name);
        Node node = ctx.state.getNode();
        this.log.trace("About to load the name child {} of context {}", (Object)name, (Object)this);
        Node child = this.sessionWrapper.getChild(node, name);
        if (child != null) {
            this.log.trace("Loaded named child {} of context {} with id {}", new Object[]{name, this, child.getUUID()});
            return this.findByNode(Object.class, child);
        }
        this.log.trace("No child named {} to load for context {}", (Object)name, (Object)this);
        return null;
    }

    @Override
    protected <T> Iterator<T> _getChildren(EntityContext ctx, Class<T> filterClass) throws RepositoryException {
        Node node = ctx.state.getNode();
        Iterator<Node> iterator = this.sessionWrapper.getChildren(node);
        return new ChildCollectionIterator<T>(this, iterator, filterClass);
    }

    @Override
    protected Object _getParent(EntityContext ctx) throws RepositoryException {
        if (ctx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node node = ctx.state.getNode();
        Node parent = this.sessionWrapper.getParent(node);
        return this.findByNode(Object.class, parent);
    }

    @Override
    protected Node _getRoot() throws RepositoryException {
        if ("/".equals(this.domain.rootNodePath)) {
            return this.sessionWrapper.getSession().getRootNode();
        }
        return (Node)this.sessionWrapper.getSession().getItem(this.domain.rootNodePath);
    }

    public void nodeRead(Node node) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        TypeMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            String id = node.getUUID();
            EntityContext ctx = this.contexts.get(id);
            if (ctx == null) {
                ctx = new EntityContext(mapper);
                this.log.trace("Inserted context {} loaded from node id {}", (Object)ctx, (Object)id);
                this.contexts.put(id, ctx);
                PersistentEntityContextState persistentState = new PersistentEntityContextState(node, this);
                ctx.state = persistentState;
                this.broadcaster.loaded(persistentState, ctx.getObject());
            } else {
                this.log.trace("Context {} is already present for id ", (Object)ctx, (Object)id);
            }
        } else {
            this.log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        }
    }

    public void nodeAdded(Node node, EntityContext ctx) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        TypeMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            String id = node.getUUID();
            if (this.contexts.containsKey(id)) {
                String msg = "Attempt to replace an existing context " + ctx + " with id " + id;
                this.log.error(msg);
                throw new AssertionError((Object)msg);
            }
            this.log.trace("Inserted context {} for id {}", (Object)ctx, (Object)id);
            this.contexts.put(id, ctx);
            PersistentEntityContextState persistentState = new PersistentEntityContextState(node, this);
            ctx.state = persistentState;
            this.broadcaster.added(persistentState, ctx.getObject());
        } else {
            this.log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        }
    }

    public void nodeRemoved(String nodeId) throws RepositoryException {
        this.log.trace("Removing context for id {}", (Object)nodeId);
        EntityContext ctx = this.contexts.remove(nodeId);
        if (ctx != null) {
            PersistentEntityContextState persistentState = (PersistentEntityContextState)ctx.state;
            ctx.state = new RemovedEntityContextState(nodeId);
            this.broadcaster.removed(persistentState, ctx.getObject());
            this.log.trace("Removed context {} for id {}", (Object)ctx, (Object)nodeId);
        } else {
            this.log.trace("Context absent for removal for id {}", (Object)ctx, (Object)nodeId);
        }
    }

    private String encodeName(EntityContext ctx, String external) {
        String internal;
        if (external == null) {
            throw new NullPointerException("No null name accepted");
        }
        ObjectFormatter formatter = null;
        if (ctx != null) {
            formatter = ctx.mapper.getFormatter();
        }
        if (formatter == null) {
            formatter = this.domain.objectFormatter;
        }
        try {
            internal = formatter.encodeNodeName(null, external);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                throw (NullPointerException)e;
            }
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (internal == null) {
            throw new IllegalArgumentException("Name " + external + " was converted to null");
        }
        JCR.validateName((String)internal);
        return internal;
    }

    private String decodeName(EntityContext ctx, String internal) {
        String external;
        ObjectFormatter formatter = null;
        if (ctx != null) {
            formatter = ctx.mapper.getFormatter();
        }
        if (formatter == null) {
            formatter = this.domain.objectFormatter;
        }
        try {
            external = formatter.decodeNodeName(null, internal);
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (external == null) {
            throw new IllegalStateException("Null name returned by decoder");
        }
        return external;
    }

    public void close() {
        this.sessionWrapper.close();
    }
}

