/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.query;

import org.chromattic.api.query.Query;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.mapper.NodeTypeMapper;
import org.chromattic.core.mapper.TypeMapper;

public class QueryBuilderImpl
implements QueryBuilder {
    private Class<?> fromClass = null;
    private String where = null;
    private NodeTypeMapper mapper;
    private DomainSession session;

    QueryBuilderImpl(DomainSession session) {
        this.session = session;
    }

    public QueryBuilder from(Class fromClass) {
        if (fromClass == null) {
            throw new NullPointerException();
        }
        if (this.fromClass != null) {
            throw new IllegalStateException();
        }
        Domain domain = this.session.getDomain();
        TypeMapper mapper = domain.getTypeMapper(fromClass);
        if (mapper == null) {
            throw new IllegalArgumentException("Class " + fromClass.getName() + " is not mapped");
        }
        if (!(mapper instanceof NodeTypeMapper)) {
            throw new IllegalArgumentException("Class " + fromClass.getName() + " is mapped to a mixin type");
        }
        this.mapper = (NodeTypeMapper)mapper;
        this.fromClass = fromClass;
        return this;
    }

    public QueryBuilder where(String whereStatement) {
        if (whereStatement == null) {
            throw new NullPointerException();
        }
        this.where = whereStatement;
        return this;
    }

    public QueryBuilder orderBy(String orderBy) throws NullPointerException {
        throw new UnsupportedOperationException("todo");
    }

    public Query get() {
        if (this.fromClass == null) {
            throw new IllegalStateException();
        }
        StringBuffer sb = new StringBuffer("SELECT * FROM ");
        sb.append(this.mapper.getNodeTypeName());
        if (this.where != null) {
            sb.append(" WHERE ");
            sb.append(this.where);
        }
        return this.session.getDomain().getQueryManager().getObjectQuery(this.session, this.mapper.getObjectClass(), sb.toString());
    }
}

