/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.property;

import org.chromattic.core.ObjectContext;
import org.chromattic.core.bean.SimpleValueInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.mapper.PropertyMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRPropertyPropertyMapper<O extends ObjectContext>
extends PropertyMapper<SingleValuedPropertyInfo<SimpleValueInfo>, O> {
    private final String jcrPropertyName;

    public JCRPropertyPropertyMapper(Class<O> contextType, SingleValuedPropertyInfo<SimpleValueInfo> info, String jcrPropertyName) {
        super(contextType, info);
        this.jcrPropertyName = jcrPropertyName;
    }

    @Override
    public Object get(O context) throws Throwable {
        SimpleValueInfo simpleValueInfo = (SimpleValueInfo)((SingleValuedPropertyInfo)this.info).getValue();
        return this.get(context, simpleValueInfo);
    }

    private <V> V get(O context, SimpleValueInfo<V> d) throws Throwable {
        return ((ObjectContext)context).getPropertyValue(this.jcrPropertyName, d);
    }

    @Override
    public void set(O context, Object o) throws Throwable {
        SimpleValueInfo simpleValueInfo = (SimpleValueInfo)((SingleValuedPropertyInfo)this.info).getValue();
        this.set(context, simpleValueInfo, o);
    }

    private <V> void set(O context, SimpleValueInfo<V> simpleValueInfo, Object o) throws Throwable {
        Class<V> javaType = simpleValueInfo.getSimpleType().getObjectType();
        V v = javaType.cast(o);
        ((ObjectContext)context).setPropertyValue(this.jcrPropertyName, simpleValueInfo, v);
    }
}

