/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.chromattic.api.ChromatticIOException;
import org.chromattic.api.NoSuchPropertyException;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.ListType;
import org.chromattic.core.jcr.info.NodeTypeInfo;
import org.chromattic.core.jcr.info.PrimaryTypeInfo;
import org.chromattic.core.jcr.info.PropertyDefinitionInfo;
import org.chromattic.core.vt.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentEntityContextState
extends EntityContextState {
    private final DomainSession session;
    private final Map<String, Object> propertyCache;
    private final Node node;
    private final PrimaryTypeInfo typeInfo;

    PersistentEntityContextState(Node node, DomainSession session) throws RepositoryException {
        this.session = session;
        this.propertyCache = session.domain.stateCacheEnabled ? new HashMap() : null;
        this.node = node;
        this.typeInfo = session.domain.nodeInfoManager.getPrimaryTypeInfo(node.getPrimaryNodeType());
    }

    @Override
    String getId() {
        try {
            return this.node.getUUID();
        }
        catch (UnsupportedRepositoryOperationException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    String getName() {
        try {
            return this.node.getName();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    void setName(String name) {
        throw new IllegalStateException("Node name are read only");
    }

    @Override
    Node getNode() {
        return this.node;
    }

    @Override
    DomainSession getSession() {
        return this.session;
    }

    @Override
    Status getStatus() {
        return Status.PERSISTENT;
    }

    @Override
    PrimaryTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    <V> V getPropertyValue(NodeTypeInfo nodeTypeInfo, String propertyName, ValueType<V> vt) {
        try {
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            Object value = null;
            if (this.propertyCache != null) {
                value = this.propertyCache.get(propertyName);
            }
            if (value == null) {
                Value[] values;
                Property property = this.session.getSessionWrapper().getProperty(this.node, propertyName);
                Object jcrValue = property != null ? (def.isMultiple() ? ((values = property.getValues()).length == 0 ? null : values[0]) : property.getValue()) : null;
                if (jcrValue != null) {
                    value = vt.get((Value)jcrValue);
                    if (this.propertyCache != null && value instanceof InputStream) {
                        try {
                            value = new CloneableInputStream((InputStream)value);
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
            if (value == null) {
                if (vt != null) {
                    List<V> defaultValue = vt.getDefaultValue();
                    if (defaultValue != null && defaultValue.size() > 0) {
                        value = defaultValue.get(0);
                    }
                    if (value == null && vt.isPrimitive()) {
                        throw new IllegalStateException("Cannot convert null to primitive type " + vt);
                    }
                }
            } else if (this.propertyCache != null) {
                if (value instanceof InputStream) {
                    value = ((CloneableInputStream)value).clone();
                } else if (value instanceof Date) {
                    value = ((Date)value).clone();
                }
            }
            return (V)value;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> List<V> getPropertyValues(NodeTypeInfo nodeTypeInfo, String propertyName, ValueType<V> vt, ListType listType) {
        try {
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            Property property = this.session.getSessionWrapper().getProperty(this.node, propertyName);
            Value[] values = property != null ? (def.isMultiple() ? property.getValues() : new Value[]{property.getValue()}) : new Value[]{};
            List<V> list = listType.create(vt, values.length);
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                V v = vt.get(value);
                list.set(i, v);
            }
            return list;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> void setPropertyValue(NodeTypeInfo nodeTypeInfo, String propertyName, ValueType<V> vt, V propertyValue) {
        try {
            int neededType;
            Value jcrValue;
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            if (this.propertyCache != null && propertyValue instanceof InputStream && propertyValue instanceof CloneableInputStream) {
                try {
                    propertyValue = new CloneableInputStream((InputStream)propertyValue);
                }
                catch (IOException e) {
                    throw new ChromatticIOException("Could not read stream", e);
                }
            }
            if (propertyValue != null) {
                ValueFactory valueFactory = this.session.sessionWrapper.getSession().getValueFactory();
                jcrValue = vt.get(valueFactory, propertyValue);
            } else {
                jcrValue = null;
            }
            if (jcrValue != null && (neededType = def.getType()) != 0 && neededType != jcrValue.getType()) {
                throw new ClassCastException("Cannot cast type " + jcrValue.getType() + " to type " + neededType + " when setting property " + propertyName);
            }
            if (def.isMultiple()) {
                if (jcrValue == null) {
                    this.node.setProperty(propertyName, new Value[0]);
                } else {
                    this.node.setProperty(propertyName, new Value[]{jcrValue});
                }
            } else {
                this.node.setProperty(propertyName, jcrValue);
            }
            if (this.propertyCache != null) {
                if (propertyValue != null) {
                    if (propertyValue instanceof InputStream) {
                        CloneableInputStream stream = (CloneableInputStream)propertyValue;
                        propertyValue = stream.clone();
                    } else if (propertyValue instanceof Date) {
                        propertyValue = ((Date)propertyValue).clone();
                    }
                    this.propertyCache.put(propertyName, propertyValue);
                } else {
                    this.propertyCache.remove(propertyName);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> void setPropertyValues(NodeTypeInfo nodeTypeInfo, String propertyName, ValueType<V> vt, ListType listType, List<V> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        try {
            PropertyDefinitionInfo def = nodeTypeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            ValueFactory valueFactory = this.session.sessionWrapper.getSession().getValueFactory();
            int size = objects.size();
            Value[] values = new Value[size];
            for (int i = 0; i < size; ++i) {
                V element = objects.get(i);
                values[i] = vt.get(valueFactory, element);
            }
            if (def.isMultiple()) {
                this.node.setProperty(propertyName, values);
            } else {
                if (values.length > 1) {
                    throw new IllegalArgumentException("Cannot update with an array of length greater than 1");
                }
                if (values.length == 1) {
                    this.node.setProperty(propertyName, values[0]);
                } else {
                    this.node.setProperty(propertyName, (Value)null);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public String toString() {
        return "ObjectStatus[path=" + this.getPath() + ",status=" + Status.PERSISTENT + "]";
    }
}

