/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr;

import java.util.Iterator;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.collection.AbstractFilterIterator;
import org.chromattic.core.jcr.AbstractLinkManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceLinkManager
extends AbstractLinkManager {
    public ReferenceLinkManager(Session session) {
        super(session);
    }

    @Override
    protected Node _getReferenced(Property property) throws RepositoryException {
        if (property.getType() == 9) {
            try {
                return property.getNode();
            }
            catch (ItemNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected void _setReferenced(Node referent, String propertyName, Node referenced) throws RepositoryException {
        referent.setProperty(propertyName, referenced);
    }

    @Override
    protected Iterator<Node> _getReferents(Node referenced, String propertyName) throws RepositoryException {
        PropertyIterator bilto = referenced.getReferences();
        return new AbstractFilterIterator<Node, Property>((Iterator)bilto){

            protected Node adapt(Property property) {
                try {
                    String propertyName = property.getName();
                    if (propertyName.equals(propertyName)) {
                        return property.getParent();
                    }
                    return null;
                }
                catch (RepositoryException e) {
                    throw new UndeclaredRepositoryException(e);
                }
            }
        };
    }
}

