/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.ArrayList;
import java.util.List;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.event.LifeCycleListener;
import org.chromattic.api.event.StateChangeListener;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.core.EntityContext;

public final class EventBroadcaster
implements EventListener {
    private List<LifeCycleListener> lifeCycleListeners = null;
    private List<StateChangeListener> stateChangeListeners;

    public void addLifeCycleListener(EventListener listener) throws NullPointerException {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (listener instanceof LifeCycleListener) {
            LifeCycleListener lifeCycleListener = (LifeCycleListener)listener;
            if (this.lifeCycleListeners == null || !this.lifeCycleListeners.contains(lifeCycleListener)) {
                if (this.lifeCycleListeners == null) {
                    this.lifeCycleListeners = new ArrayList<LifeCycleListener>();
                }
                this.lifeCycleListeners.add(lifeCycleListener);
            }
        }
        if (listener instanceof StateChangeListener) {
            StateChangeListener stateChangeListener = (StateChangeListener)listener;
            if (this.stateChangeListeners == null || !this.stateChangeListeners.contains(stateChangeListener)) {
                if (this.stateChangeListeners == null) {
                    this.stateChangeListeners = new ArrayList<StateChangeListener>();
                }
                this.stateChangeListeners.add(stateChangeListener);
            }
        }
    }

    public boolean hasLifeCycleListeners() {
        return this.lifeCycleListeners != null;
    }

    public boolean hasStateChangeListeners() {
        return this.stateChangeListeners != null;
    }

    public void created(Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.created(o);
            }
            catch (Exception ignore) {}
        }
    }

    public void loaded(EntityContext ctx, Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        String id = ctx.getId();
        String path = ctx.getPath();
        String name = ctx.getName();
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.loaded(id, path, name, o);
            }
            catch (Exception ignore) {}
        }
    }

    public void added(EntityContext ctx, Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        String id = ctx.getId();
        String path = ctx.getPath();
        String name = ctx.getName();
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.added(id, path, name, o);
            }
            catch (Exception ignore) {}
        }
    }

    public void removed(String id, String path, String name, Object o) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        for (LifeCycleListener listener : this.lifeCycleListeners) {
            try {
                listener.removed(id, path, name, o);
            }
            catch (Exception ignore) {}
        }
    }

    public void propertyChanged(String id, Object o, String propertyName, Object propertyValue) {
        if (this.stateChangeListeners == null) {
            return;
        }
        for (StateChangeListener listener : this.stateChangeListeners) {
            try {
                if (propertyValue instanceof CloneableInputStream) {
                    listener.propertyChanged(id, o, propertyName, (Object)((CloneableInputStream)propertyValue).clone());
                    continue;
                }
                listener.propertyChanged(id, o, propertyName, propertyValue);
            }
            catch (Exception ignore) {}
        }
    }
}

