/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.api;

import javax.jcr.RepositoryException;
import org.chromattic.api.Path;
import org.chromattic.api.PropertyLiteral;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.core.EntityContext;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.RelationshipMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPathBuilder<O>
implements Path<O> {
    private final BeanMapping mapping;

    AbstractPathBuilder(BeanMapping mapping) {
        this.mapping = mapping;
    }

    public Path<?> parent() {
        throw new UnsupportedOperationException();
    }

    public <P> Path<P> parent(PropertyLiteral<O, P> property) {
        throw new UnsupportedOperationException();
    }

    public <P> Path<P> child(PropertyLiteral<O, P> property, String childName) {
        RelationshipMapping.OneToMany.Hierarchic childMapping = (RelationshipMapping.OneToMany.Hierarchic)this.mapping.getPropertyMapping(property.getName(), RelationshipMapping.OneToMany.Hierarchic.class);
        if (childMapping == null) {
            throw new IllegalArgumentException();
        }
        for (PropertyMapping pm : this.mapping.getProperties().values()) {
            RelationshipMapping.OneToOne.Hierarchic oto;
            if (!(pm instanceof RelationshipMapping.OneToOne.Hierarchic) || !(oto = (RelationshipMapping.OneToOne.Hierarchic)pm).isOwner() || !oto.getMappedBy().equals(childName)) continue;
            throw new IllegalArgumentException();
        }
        return new AnyChild(this, childMapping, childName);
    }

    public <P> Path<P> child(PropertyLiteral<O, P> property) {
        RelationshipMapping.OneToOne.Hierarchic childMapping = (RelationshipMapping.OneToOne.Hierarchic)this.mapping.getPropertyMapping(property.getName(), RelationshipMapping.OneToOne.Hierarchic.class);
        if (childMapping == null) {
            throw new IllegalArgumentException();
        }
        if (!childMapping.isOwner()) {
            throw new IllegalArgumentException();
        }
        return new Child(this, childMapping);
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public O object() {
        throw new UnsupportedOperationException();
    }

    protected abstract void appendTo(StringBuilder var1) throws RepositoryException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Root<O>
    extends AbstractPathBuilder<O> {
        private final EntityContext context;

        public Root(EntityContext context) {
            super(context.getMapper().getMapping());
            this.context = context;
        }

        @Override
        protected void appendTo(StringBuilder sb) throws RepositoryException {
            sb.append(this.context.getNode().getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Child<O>
    extends AbstractPathBuilder<O> {
        private final AbstractPathBuilder<?> parent;
        private final RelationshipMapping.OneToOne.Hierarchic relationship;

        private Child(AbstractPathBuilder<?> parent, RelationshipMapping.OneToOne.Hierarchic relationship) {
            super(relationship.getRelatedBeanMapping());
            this.parent = parent;
            this.relationship = relationship;
        }

        @Override
        protected void appendTo(StringBuilder sb) throws RepositoryException {
            this.parent.appendTo(sb);
            sb.append('/').append(this.relationship.getMappedBy());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnyChild<O>
    extends AbstractPathBuilder<O> {
        private final AbstractPathBuilder<?> parent;
        private final RelationshipMapping.OneToMany.Hierarchic relationship;
        private final String name;

        AnyChild(AbstractPathBuilder<?> parent, RelationshipMapping.OneToMany.Hierarchic relationship, String name) {
            super(relationship.getRelatedBeanMapping());
            this.parent = parent;
            this.relationship = relationship;
            this.name = name;
        }

        @Override
        protected void appendTo(StringBuilder sb) throws RepositoryException {
            this.parent.appendTo(sb);
            sb.append('/').append(this.name);
        }
    }
}

