/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.core.MethodInvoker;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.reflext.api.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMapper<C extends ObjectContext<C>> {
    private final BeanMapping mapping;
    protected final Class<?> objectClass;
    private final String nodeTypeName;
    final Set<MethodMapper<C>> methodMappers;
    final Set<PropertyMapper<?, ?, C>> propertyMappers;
    private final Map<Method, MethodInvoker<C>> dispatchers;
    private final ObjectFormatter formatter;
    private final NameConflictResolution onDuplicate;
    private final NodeTypeKind kind;
    private final boolean abstract_;
    private final Map<String, PropertyMapper<?, ?, C>> propertyMapperMap;

    public ObjectMapper(BeanMapping mapping, boolean abstract_, Class<?> objectClass, Set<PropertyMapper<?, ?, C>> propertyMappers, Set<MethodMapper<C>> methodMappers, NameConflictResolution onDuplicate, ObjectFormatter formatter, String typeName, NodeTypeKind kind) {
        HashMap propertyMapperMap = new HashMap();
        for (PropertyMapper<?, ?, C> propertyMapper : propertyMappers) {
            propertyMapperMap.put(propertyMapper.getInfo().getName(), propertyMapper);
        }
        HashMap<Method, MethodInvoker<C>> dispatchers = new HashMap<Method, MethodInvoker<C>>();
        for (PropertyMapper<?, ?, C> propertyMapper : propertyMappers) {
            MethodInfo setter;
            PropertyMapping<?, ?> info = propertyMapper.getInfo();
            MethodInfo getter = info.getProperty().getGetter();
            if (getter != null) {
                dispatchers.put((Method)getter.unwrap(), propertyMapper.getGetter());
            }
            if ((setter = info.getProperty().getSetter()) == null) continue;
            dispatchers.put((Method)setter.unwrap(), propertyMapper.getSetter());
        }
        for (MethodMapper methodMapper : methodMappers) {
            dispatchers.put((Method)methodMapper.getMethod().unwrap(), methodMapper);
        }
        this.mapping = mapping;
        this.abstract_ = abstract_;
        this.dispatchers = dispatchers;
        this.objectClass = objectClass;
        this.methodMappers = methodMappers;
        this.formatter = formatter;
        this.onDuplicate = onDuplicate;
        this.propertyMappers = propertyMappers;
        this.nodeTypeName = typeName;
        this.kind = kind;
        this.propertyMapperMap = propertyMapperMap;
    }

    public MethodInvoker<C> getInvoker(Method method) {
        return this.dispatchers.get(method);
    }

    public BeanMapping getMapping() {
        return this.mapping;
    }

    public boolean isAbstract() {
        return this.abstract_;
    }

    public NodeTypeKind getKind() {
        return this.kind;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public ObjectFormatter getFormatter() {
        return this.formatter;
    }

    public Set<MethodMapper<C>> getMethodMappers() {
        return this.methodMappers;
    }

    public Set<PropertyMapper<?, ?, C>> getPropertyMappers() {
        return this.propertyMappers;
    }

    public PropertyMapper<?, ?, C> getPropertyMapper(String name) {
        return this.propertyMapperMap.get(name);
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public NameConflictResolution getOnDuplicate() {
        return this.onDuplicate;
    }

    public String toString() {
        return "EntityMapper[class=" + this.objectClass + ",typeName=" + this.nodeTypeName + "]";
    }
}

