/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.ArrayList;
import java.util.List;
import org.chromattic.common.collection.wrapped.WrappedArrayList;
import org.chromattic.core.vt2.ValueDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListType {
    public static final ListType ARRAY = new ListType(){

        @Override
        public <E> List<E> create(ValueDefinition<?, E> elementType, int size) {
            return WrappedArrayList.create(elementType.getObjectType(), elementType.getRealType(), (int)size);
        }

        @Override
        public <E> List<E> wrap(ValueDefinition<?, E> elementType, Object array) {
            return WrappedArrayList.wrap(elementType.getObjectType(), (Object)array);
        }

        @Override
        public <E> Object unwrap(ValueDefinition<?, E> elementType, List<E> list) {
            return ((WrappedArrayList)list).getArray();
        }
    };
    public static final ListType LIST = new ListType(){

        @Override
        public <E> List<E> create(ValueDefinition<?, E> elementType, int size) {
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(null);
            }
            return list;
        }

        @Override
        public <E> List<E> wrap(ValueDefinition<?, E> elementType, Object array) {
            return (List)array;
        }

        @Override
        public <E> Object unwrap(ValueDefinition<?, E> elementType, List<E> list) {
            return list;
        }
    };

    public abstract <E> List<E> create(ValueDefinition<?, E> var1, int var2);

    public abstract <E> Object unwrap(ValueDefinition<?, E> var1, List<E> var2);

    public abstract <E> List<E> wrap(ValueDefinition<?, E> var1, Object var2);
}

