/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.api.UndeclaredRepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSet
extends AbstractSet<Node> {
    private HashMap<String, Node> map = null;

    @Override
    public boolean contains(Object o) {
        if (this.map != null && o instanceof Node) {
            try {
                return this.map.containsKey(((Node)o).getUUID());
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }
        return false;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.map != null ? this.map.values().iterator() : Collections.emptyList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }

    @Override
    public boolean add(Node node) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        try {
            return this.map.put(node.getUUID(), node) != null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Node> c) {
        boolean changed = false;
        for (Node node : c) {
            if (!(node instanceof Node)) continue;
            changed |= this.add(node);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.map == null) {
            return false;
        }
        Set<String> keys = this.keys(c);
        return this.map.keySet().retainAll(keys);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.map == null) {
            return false;
        }
        Set<String> keys = this.keys(c);
        return this.map.keySet().removeAll(keys);
    }

    private Set<String> keys(Collection<?> c) {
        HashSet<String> keys = new HashSet<String>();
        for (Object o : c) {
            if (!(o instanceof Node)) continue;
            try {
                keys.add(((Node)o).getUUID());
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }
        return keys;
    }
}

