/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.dataobject;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.dataobject.CompilationSource;
import org.chromattic.dataobject.DataObjectException;
import org.chromattic.dataobject.NodeTypeFormat;
import org.chromattic.metamodel.typegen.CNDNodeTypeSerializer;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.SchemaBuilder;
import org.chromattic.metamodel.typegen.XMLNodeTypeSerializer;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyCompiler;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;
import org.reflext.spi.model.ReflectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectCompiler {
    private final JcrGroovyCompiler compiler;
    private final CompilationSource source;
    private final String[] doPaths;
    private Class[] classes;

    public DataObjectCompiler(JcrGroovyCompiler compiler, CompilationSource source, String ... doPaths) throws NullPointerException, IllegalArgumentException, DataObjectException {
        if (compiler == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException("No null source accepted");
        }
        for (String doPath : doPaths = (String[])doPaths.clone()) {
            if (doPath != null) continue;
            throw new IllegalArgumentException("Data object paths must not contain a null value");
        }
        this.compiler = compiler;
        this.source = source;
        this.doPaths = doPaths;
        this.classes = null;
    }

    public DataObjectCompiler(CompilationSource source, String ... doPaths) throws DataObjectException {
        this(new JcrGroovyCompiler(), source, doPaths);
    }

    public String generateSchema(NodeTypeFormat format) throws DataObjectException, NullPointerException, IllegalArgumentException {
        XMLNodeTypeSerializer serializer;
        Map<String, NodeType> doNodeTypes = this.generateSchema();
        switch (format) {
            case EXO: {
                serializer = new XMLNodeTypeSerializer();
                break;
            }
            case CND: {
                serializer = new CNDNodeTypeSerializer();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (NodeType nodeType : doNodeTypes.values()) {
            serializer.addNodeType(nodeType);
        }
        try {
            StringWriter writer = new StringWriter();
            serializer.writeTo((Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new DataObjectException("Unexpected io exception", e);
        }
    }

    public Map<String, NodeType> generateSchema() throws DataObjectException, NullPointerException, IllegalArgumentException {
        Map<String, Class<?>> classes = this.generateClasses();
        TypeResolver domain = TypeResolverImpl.create((ReflectionModel)JavaLangReflectReflectionModel.getInstance());
        HashMap<ClassTypeInfo, String> doClassTypes = new HashMap<ClassTypeInfo, String>();
        for (Map.Entry<String, Class<?>> entry : classes.entrySet()) {
            doClassTypes.put((ClassTypeInfo)domain.resolve(entry.getValue()), entry.getKey());
        }
        HashMap<String, NodeType> doNodeTypes = new HashMap<String, NodeType>();
        for (Map.Entry entry : new SchemaBuilder().build(doClassTypes.keySet()).entrySet()) {
            ClassTypeInfo doClassType = (ClassTypeInfo)entry.getKey();
            NodeType doNodeType = (NodeType)entry.getValue();
            String doPath = (String)doClassTypes.get(doClassType);
            doNodeTypes.put(doPath, doNodeType);
        }
        return doNodeTypes;
    }

    public Map<String, Class<?>> generateClasses() throws DataObjectException, NullPointerException, IllegalArgumentException {
        Class[] classes = this.generateAllClasses();
        int i = 0;
        HashMap doClasses = new HashMap();
        for (Class clazz : classes) {
            if (!clazz.isAnnotationPresent(PrimaryType.class) && !clazz.isAnnotationPresent(MixinType.class)) continue;
            doClasses.put(this.doPaths[i++], clazz);
        }
        return doClasses;
    }

    public Class[] generateAllClasses() throws DataObjectException, NullPointerException, IllegalArgumentException {
        if (this.classes == null) {
            try {
                UnifiedNodeReference[] doRefs = new UnifiedNodeReference[this.doPaths.length];
                for (int i = 0; i < this.doPaths.length; ++i) {
                    doRefs[i] = new UnifiedNodeReference(this.source.getRepositoryRef(), this.source.getWorkspaceRef(), this.doPaths[i]);
                }
                URL url = new UnifiedNodeReference(this.source.getRepositoryRef(), this.source.getWorkspaceRef(), this.source.getPath()).getURL();
                return this.compiler.compile(new SourceFolder[]{new SourceFolder(url)}, doRefs);
            }
            catch (IOException e) {
                throw new DataObjectException("Could not generate data object classes", e);
            }
        }
        return this.classes;
    }
}

