/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.util.Map;
import junit.framework.TestCase;
import org.chromattic.metamodel.bean.BeanFilter;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanInfoBuilder;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;
import org.reflext.spi.model.ReflectionModel;

public class ClassPathResolutionTestCase
extends TestCase {
    private ClassTypeInfo cti;

    protected void setUp() throws Exception {
        TypeResolver domain = TypeResolverImpl.create((ReflectionModel)JavaLangReflectReflectionModel.getInstance());
        this.cti = (ClassTypeInfo)domain.resolve(B.class);
    }

    public void testAcceptRelated() {
        BeanInfoBuilder info = new BeanInfoBuilder(new BeanFilter(){

            public boolean accept(ClassTypeInfo cti) {
                return cti.getName().equals(A.class.getName());
            }
        });
        Map beans = info.build(new ClassTypeInfo[]{this.cti});
        ClassPathResolutionTestCase.assertEquals((int)2, (int)beans.size());
        BeanInfo bBI = (BeanInfo)beans.get(this.cti);
        SingleValuedPropertyInfo relatedPI = (SingleValuedPropertyInfo)bBI.getProperty("related");
        BeanValueInfo relatedVI = (BeanValueInfo)relatedPI.getValue();
        BeanInfo aBI = relatedVI.getBean();
        ClassPathResolutionTestCase.assertEquals((String)A.class.getName(), (String)aBI.getClassType().getName());
        ClassPathResolutionTestCase.assertTrue((boolean)beans.containsKey(aBI.getClassType()));
    }

    public void testRejectRelated() {
        BeanInfoBuilder info = new BeanInfoBuilder(new BeanFilter(){

            public boolean accept(ClassTypeInfo cti) {
                return false;
            }
        });
        Map a = info.build(new ClassTypeInfo[]{this.cti});
        ClassPathResolutionTestCase.assertEquals((int)1, (int)a.size());
        BeanInfo bBI = (BeanInfo)a.get(this.cti);
        SingleValuedPropertyInfo relatedPI = (SingleValuedPropertyInfo)bBI.getProperty("related");
        SimpleValueInfo relatedVI = (SimpleValueInfo)relatedPI.getValue();
        ClassPathResolutionTestCase.assertEquals((String)A.class.getName(), (String)relatedVI.getDeclaredType().getName());
    }

    public void testAcceptObject() {
        BeanInfoBuilder info = new BeanInfoBuilder(new BeanFilter(){

            public boolean accept(ClassTypeInfo cti) {
                return cti.getName().equals(Object.class.getName());
            }
        });
        Map beans = info.build(new ClassTypeInfo[]{this.cti});
        ClassPathResolutionTestCase.assertEquals((int)2, (int)beans.size());
        BeanInfo bBI = (BeanInfo)beans.get(this.cti);
        BeanInfo objectBI = bBI.getParent();
        ClassPathResolutionTestCase.assertNotNull((Object)objectBI);
        ClassPathResolutionTestCase.assertEquals((String)Object.class.getName(), (String)objectBI.getClassType().getName());
    }

    class B {
        B() {
        }

        A getRelated() {
            return null;
        }
    }

    class A {
        A() {
        }
    }
}

