/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.chromattic.common.collection.Collections;
import org.chromattic.metamodel.bean.BeanFilter;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.MultiValueKind;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.type.SimpleTypeMapping;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyVisitor;
import org.reflext.api.visit.HierarchyVisitorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfoBuilder {
    private final SimpleTypeResolver simpleTypeResolver;
    private final BeanFilter filter;

    public BeanInfoBuilder() {
        this((BeanFilter)null);
    }

    public BeanInfoBuilder(SimpleTypeResolver simpleTypeResolver) {
        this(simpleTypeResolver, null);
    }

    public BeanInfoBuilder(SimpleTypeResolver simpleTypeResolver, BeanFilter filter) {
        this.simpleTypeResolver = simpleTypeResolver;
        this.filter = filter;
    }

    public BeanInfoBuilder(BeanFilter filter) {
        this(new SimpleTypeResolver(), filter);
    }

    public Map<ClassTypeInfo, BeanInfo> build(ClassTypeInfo ... classTypes) {
        return this.build(Collections.set((Object[])classTypes));
    }

    public Map<ClassTypeInfo, BeanInfo> build(Set<ClassTypeInfo> classTypes) {
        Context ctx = new Context(classTypes);
        ctx.build();
        return ctx.beans;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context {
        private final Set<ClassTypeInfo> classTypes;
        private final Map<ClassTypeInfo, BeanInfo> beans;

        private Context(Set<ClassTypeInfo> classTypes) {
            this.classTypes = classTypes;
            this.beans = new HashMap<ClassTypeInfo, BeanInfo>();
        }

        void build() {
            Iterator<ClassTypeInfo> iterator;
            while ((iterator = this.classTypes.iterator()).hasNext()) {
                ClassTypeInfo cti = iterator.next();
                BeanInfo beanInfo = this.resolve(cti);
            }
        }

        BeanInfo resolve(ClassTypeInfo classType) {
            BeanInfo bean = this.beans.get(classType);
            if (bean == null) {
                Boolean declared;
                boolean accept;
                if (classType.getKind() == ClassKind.CLASS || classType.getKind() == ClassKind.INTERFACE) {
                    if (classType instanceof SimpleTypeInfo) {
                        accept = false;
                        declared = null;
                    } else if (classType instanceof VoidTypeInfo) {
                        accept = false;
                        declared = null;
                    } else if (this.classTypes.remove(classType)) {
                        accept = true;
                        declared = true;
                    } else if (BeanInfoBuilder.this.filter != null && BeanInfoBuilder.this.filter.accept(classType)) {
                        accept = true;
                        declared = false;
                    } else {
                        accept = false;
                        declared = null;
                    }
                } else {
                    accept = false;
                    declared = null;
                }
                if (accept) {
                    bean = new BeanInfo(classType, declared);
                    this.beans.put(classType, bean);
                    this.build(bean);
                }
            }
            return bean;
        }

        void build(BeanInfo bean) {
            for (ClassTypeInfo ancestorClassType = bean.classType.getSuperClass(); ancestorClassType != null; ancestorClassType = ancestorClassType.getSuperClass()) {
                BeanInfo ancestorBean = this.resolve(ancestorClassType);
                if (ancestorBean == null) continue;
                bean.parent = ancestorBean;
                break;
            }
            this.buildProperties(bean);
        }

        private PropertyInfo resolveProperty(BeanInfo bean, String propertyName) {
            if (bean == null) {
                return null;
            }
            if (bean.properties == null) {
                throw new AssertionError();
            }
            PropertyInfo property = bean.properties.get(propertyName);
            if (property == null) {
                property = this.resolveProperty(bean.parent, propertyName);
            }
            return property;
        }

        private void buildProperties(BeanInfo bean) {
            String name;
            BeanHierarchyVisitorStrategy strategy = new BeanHierarchyVisitorStrategy(bean.classType);
            MethodIntrospector introspector = new MethodIntrospector(strategy, true);
            Map getterMap = introspector.getGetterMap(bean.classType);
            Map setterMap = introspector.getSetterMap(bean.classType);
            HashMap<String, ToBuild> toBuilds = new HashMap<String, ToBuild>();
            for (Map.Entry getterEntry : getterMap.entrySet()) {
                name = (String)getterEntry.getKey();
                MethodInfo getter = (MethodInfo)getterEntry.getValue();
                TypeInfo getterTypeInfo = getter.getReturnType();
                ToBuild toBuild = null;
                Set setters = (Set)setterMap.get(name);
                if (setters != null) {
                    for (MethodInfo setter : setters) {
                        TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                        if (!getterTypeInfo.equals(setterTypeInfo)) continue;
                        toBuild = new ToBuild(getterTypeInfo, getter, setter);
                        break;
                    }
                }
                if (toBuild == null) {
                    toBuild = new ToBuild(getterTypeInfo, getter, null);
                }
                if (toBuild == null) continue;
                toBuilds.put(name, toBuild);
            }
            setterMap.keySet().removeAll(toBuilds.keySet());
            for (Map.Entry setterEntry : setterMap.entrySet()) {
                name = (String)setterEntry.getKey();
                for (MethodInfo setter : (Set)setterEntry.getValue()) {
                    TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                    toBuilds.put(name, new ToBuild(setterTypeInfo, null, setter));
                }
            }
            HashMap<String, SingleValuedPropertyInfo<SimpleValueInfo>> properties = new HashMap<String, SingleValuedPropertyInfo<SimpleValueInfo>>();
            for (Map.Entry toBuildEntry : toBuilds.entrySet()) {
                BeanInfo related;
                PropertyInfo parentProperty = this.resolveProperty(bean.parent, (String)toBuildEntry.getKey());
                TypeInfo type = ((ToBuild)toBuildEntry.getValue()).type;
                TypeInfo resolvedType = bean.classType.resolve(type);
                PropertyInfo property = null;
                if (resolvedType instanceof TypeVariableInfo) {
                    resolvedType = (TypeInfo)((TypeVariableInfo)resolvedType).getBounds().get(0);
                    resolvedType = bean.classType.resolve(resolvedType);
                }
                if (resolvedType instanceof ParameterizedTypeInfo) {
                    ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)resolvedType;
                    TypeInfo rawType = parameterizedType.getRawType();
                    if (rawType instanceof ClassTypeInfo) {
                        ClassTypeInfo elementClassType;
                        TypeInfo elementType;
                        MultiValueKind collectionKind;
                        ClassTypeInfo rawClassType = (ClassTypeInfo)rawType;
                        String rawClassName = rawClassType.getName();
                        if (rawClassName.equals("java.util.Collection")) {
                            collectionKind = MultiValueKind.COLLECTION;
                            elementType = (TypeInfo)parameterizedType.getTypeArguments().get(0);
                        } else if (rawClassName.equals("java.util.List")) {
                            collectionKind = MultiValueKind.LIST;
                            elementType = (TypeInfo)parameterizedType.getTypeArguments().get(0);
                        } else if (rawClassName.equals("java.util.Map")) {
                            TypeInfo keyType = (TypeInfo)parameterizedType.getTypeArguments().get(0);
                            TypeInfo resolvedKeyType = bean.classType.resolve(keyType);
                            if (resolvedKeyType instanceof ClassTypeInfo && ((ClassTypeInfo)resolvedKeyType).getName().equals("java.lang.String")) {
                                elementType = (TypeInfo)parameterizedType.getTypeArguments().get(1);
                                collectionKind = MultiValueKind.MAP;
                            } else {
                                elementType = null;
                                collectionKind = null;
                            }
                        } else {
                            elementType = null;
                            collectionKind = null;
                        }
                        if (collectionKind != null && (elementClassType = bean.resolveToClass(elementType)) != null) {
                            BeanInfo relatedBean = this.resolve(elementClassType);
                            property = relatedBean != null ? new MultiValuedPropertyInfo<BeanValueInfo>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, collectionKind, new BeanValueInfo(type, bean.resolveToClass(elementType), relatedBean)) : new MultiValuedPropertyInfo<SimpleValueInfo>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, collectionKind, this.createSimpleValueInfo(bean, elementType));
                        }
                    }
                } else if (resolvedType instanceof ArrayTypeInfo) {
                    TypeInfo componentType = ((ArrayTypeInfo)resolvedType).getComponentType();
                    if (componentType instanceof SimpleTypeInfo) {
                        SimpleTypeInfo componentSimpleType = (SimpleTypeInfo)componentType;
                        switch (componentSimpleType.getLiteralType()) {
                            case BOOLEAN: 
                            case DOUBLE: 
                            case FLOAT: 
                            case LONG: 
                            case INT: {
                                property = new MultiValuedPropertyInfo<SimpleValueInfo>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, MultiValueKind.ARRAY, this.createSimpleValueInfo(bean, componentType));
                                break;
                            }
                        }
                    } else {
                        property = new MultiValuedPropertyInfo<SimpleValueInfo>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, MultiValueKind.ARRAY, this.createSimpleValueInfo(bean, componentType));
                    }
                } else if (resolvedType instanceof ClassTypeInfo && (related = this.resolve((ClassTypeInfo)resolvedType)) != null) {
                    property = new SingleValuedPropertyInfo<BeanValueInfo>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, new BeanValueInfo(type, bean.resolveToClass(type), related));
                }
                if (property == null) {
                    property = new SingleValuedPropertyInfo<SimpleValueInfo>(bean, parentProperty, (String)toBuildEntry.getKey(), ((ToBuild)toBuildEntry.getValue()).getter, ((ToBuild)toBuildEntry.getValue()).setter, this.createSimpleValueInfo(bean, type));
                }
                properties.put(property.getName(), (SingleValuedPropertyInfo<SimpleValueInfo>)property);
            }
            bean.properties.putAll(properties);
        }

        private SimpleValueInfo createSimpleValueInfo(BeanInfo bean, TypeInfo type) {
            TypeInfo resolvedType = bean.getClassType().resolve(type);
            SimpleTypeMapping mapping = BeanInfoBuilder.this.simpleTypeResolver.resolveType(resolvedType);
            return new SimpleValueInfo(type, resolvedType, mapping);
        }

        class ToBuild {
            final TypeInfo type;
            final MethodInfo getter;
            final MethodInfo setter;

            ToBuild(TypeInfo type, MethodInfo getter, MethodInfo setter) {
                this.type = type;
                this.getter = getter;
                this.setter = setter;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BeanHierarchyVisitorStrategy<V extends HierarchyVisitor<V>>
        extends HierarchyVisitorStrategy<V> {
            private final ClassTypeInfo current;

            private BeanHierarchyVisitorStrategy(ClassTypeInfo current) {
                this.current = current;
            }

            protected boolean accept(ClassTypeInfo type) {
                return type == this.current || !Context.this.classTypes.contains(type);
            }
        }
    }
}

