/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.PropertyType;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.NodeTypeSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNDNodeTypeSerializer
extends NodeTypeSerializer {
    private PrintWriter writer;

    public CNDNodeTypeSerializer(List<NodeType> nodeTypes) {
        super(nodeTypes);
    }

    public CNDNodeTypeSerializer(List<NodeType> nodeTypes, Map<String, String> mappings) {
        super(nodeTypes, mappings);
    }

    public CNDNodeTypeSerializer(Map<String, String> mappings) {
        super(mappings);
    }

    public CNDNodeTypeSerializer() {
    }

    @Override
    public void writeTo(Writer writer) throws Exception {
        this.writer = new PrintWriter(writer);
        this.writeTo();
    }

    @Override
    public void startNodeTypes(Map<String, String> mappings) throws Exception {
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            this.writer.append('<').append(mapping.getKey()).append(" = ").append('\'').append(mapping.getValue()).append("'>\n");
        }
    }

    @Override
    public void startNodeType(String javaClassName, String name, boolean mixin, boolean orderableChildNodes, Collection<String> superTypeNames) throws Exception {
        this.writer.print("[");
        this.writer.print(name);
        this.writer.print("]");
        int count = 0;
        for (String superTypeName : superTypeNames) {
            if (count == 0) {
                this.writer.print(" > ");
            } else {
                this.writer.print(", ");
            }
            this.writer.print(superTypeName);
            ++count;
        }
        this.writer.println();
        if (orderableChildNodes) {
            this.writer.println("orderable");
        }
        if (mixin) {
            this.writer.println("mixin");
        }
    }

    @Override
    public void property(String name, int requiredType, boolean multiple, Collection<String> defaultValues) throws Exception {
        this.writer.print("- ");
        this.writer.print(name);
        this.writer.print(" (");
        this.writer.print(PropertyType.nameFromValue((int)requiredType));
        this.writer.println(")");
        if (defaultValues != null) {
            int count = 0;
            for (String defaultValue : defaultValues) {
                if (count == 0) {
                    this.writer.print("= ");
                } else {
                    this.writer.print(", ");
                }
                this.writer.print(defaultValue);
                ++count;
            }
            this.writer.println();
        }
        if (multiple) {
            this.writer.println("multiple");
        }
    }

    @Override
    public void childNode(String name, String nodeTypeName, boolean mandatory, boolean autocreated) throws Exception {
        this.writer.print("+ ");
        this.writer.print(name);
        this.writer.print(" (");
        this.writer.print(nodeTypeName);
        this.writer.print(")");
        this.writer.print(" =");
        this.writer.print(nodeTypeName);
        if (mandatory) {
            this.writer.print(" mandatory");
        }
        if (autocreated) {
            this.writer.print(" autocreated");
        }
        this.writer.println();
    }
}

