/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen.onetoone.embedded;

import java.util.Map;
import org.chromattic.common.collection.Collections;
import org.chromattic.metamodel.typegen.AbstractSchemaTestCase;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.TypeGen;
import org.chromattic.metamodel.typegen.onetoone.embedded.A1;
import org.chromattic.metamodel.typegen.onetoone.embedded.A2;
import org.chromattic.metamodel.typegen.onetoone.embedded.A3;
import org.chromattic.metamodel.typegen.onetoone.embedded.A4;
import org.chromattic.metamodel.typegen.onetoone.embedded.B1;
import org.chromattic.metamodel.typegen.onetoone.embedded.B2;

public class EmbeddedTypeTestCase
extends AbstractSchemaTestCase {
    public void testOwnerMixinType() {
        Map<Class<?>, NodeType> a = this.assertValid(B1.class, B2.class);
        TypeGen gen = new TypeGen();
        gen.generate();
        NodeType b1NT = a.get(B1.class);
        EmbeddedTypeTestCase.assertEquals((String)"b1", (String)b1NT.getName());
        EmbeddedTypeTestCase.assertEquals((Object)Collections.set((Object[])new String[0]), b1NT.getPropertyDefinitions().keySet());
        NodeType b2NT = a.get(B2.class);
        EmbeddedTypeTestCase.assertEquals((String)"b2", (String)b2NT.getName());
        EmbeddedTypeTestCase.assertEquals((Object)Collections.set((Object[])new String[]{"foo"}), b2NT.getPropertyDefinitions().keySet());
        EmbeddedTypeTestCase.assertFalse((boolean)b2NT.getDeclaredSuperTypes().contains(b1NT));
        EmbeddedTypeTestCase.assertFalse((boolean)b1NT.getDeclaredSuperTypes().contains(b2NT));
    }

    public void testOwnerSuperType() {
        Map<Class<?>, NodeType> a = this.assertValid(A1.class, A2.class);
        NodeType a1NT = a.get(A1.class);
        EmbeddedTypeTestCase.assertEquals((String)"a1", (String)a1NT.getName());
        NodeType a2NT = a.get(A2.class);
        EmbeddedTypeTestCase.assertEquals((String)"a2", (String)a2NT.getName());
        EmbeddedTypeTestCase.assertTrue((boolean)a2NT.getDeclaredSuperTypes().contains(a1NT));
        EmbeddedTypeTestCase.assertFalse((boolean)a1NT.getDeclaredSuperTypes().contains(a2NT));
    }

    public void testOwnedSuperType() {
        Map<Class<?>, NodeType> a = this.assertValid(A3.class, A4.class);
        NodeType a3NT = a.get(A3.class);
        EmbeddedTypeTestCase.assertEquals((String)"a3", (String)a3NT.getName());
        NodeType a4NT = a.get(A4.class);
        EmbeddedTypeTestCase.assertEquals((String)"a4", (String)a4NT.getName());
        EmbeddedTypeTestCase.assertFalse((boolean)a4NT.getDeclaredSuperTypes().contains(a3NT));
        EmbeddedTypeTestCase.assertTrue((boolean)a3NT.getDeclaredSuperTypes().contains(a4NT));
    }
}

