/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator.sourcetransformer;

import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.type.Type;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.List;
import org.chromattic.testgenerator.sourcetransformer.TransformationSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitChromatticVisitor
extends VoidVisitorAdapter
implements TransformationSource {
    private List<AnnotationExpr> annotationExprs = new ArrayList<AnnotationExpr>();
    private List<MethodCallExpr> methodCallExprs = new ArrayList<MethodCallExpr>();

    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        if (n.getAnnotations() != null) {
            this.annotationExprs.addAll(n.getAnnotations());
        }
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        n.setModifiers(n.getModifiers() & 0xFFFFFBFF & 0xFFFFFFFE);
        for (BodyDeclaration bodyDeclaration : n.getMembers()) {
            if (!(bodyDeclaration instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            if (methodDeclaration.getAnnotations() != null) {
                this.annotationExprs.addAll(methodDeclaration.getAnnotations());
            }
            fieldInfos.add(new FieldInfo(methodDeclaration.getType(), methodDeclaration.getName(), methodDeclaration.getAnnotations(), methodDeclaration));
        }
        ArrayList<MethodDeclaration> methodToRemove = new ArrayList<MethodDeclaration>();
        for (FieldInfo fieldInfo : fieldInfos) {
            try {
                FieldDeclaration fieldDeclaration = new FieldDeclaration(2, fieldInfo.getType(), new VariableDeclarator(new VariableDeclaratorId(UnitChromatticVisitor.fieldName(fieldInfo.getName()))));
                fieldDeclaration.setAnnotations(new ArrayList());
                if (fieldInfo.getAnnotationExprs() != null) {
                    for (AnnotationExpr annotationExpr : fieldInfo.getAnnotationExprs()) {
                        if (annotationExpr.getName().getName().equals("Override") || annotationExpr.getName().getName().equals("Skip")) continue;
                        fieldDeclaration.getAnnotations().add(annotationExpr);
                    }
                }
                if (fieldInfo.getName().startsWith("get")) {
                    n.getMembers().add(fieldDeclaration);
                    for (BodyDeclaration bodyDeclaration : n.getMembers()) {
                        MethodDeclaration methodDeclaration;
                        if (!(bodyDeclaration instanceof MethodDeclaration) || !(methodDeclaration = (MethodDeclaration)bodyDeclaration).getName().equals(fieldInfo.getName().replace("get", "set")) || methodDeclaration.getAnnotations() == null) continue;
                        fieldDeclaration.getAnnotations().addAll(methodDeclaration.getAnnotations());
                    }
                }
                methodToRemove.add(fieldInfo.getSourceDeclaration());
            }
            catch (IllegalArgumentException e) {}
        }
        for (MethodDeclaration methodDeclaration : methodToRemove) {
            n.getMembers().remove(methodDeclaration);
        }
        if (n.getAnnotations() != null) {
            this.annotationExprs.addAll(n.getAnnotations());
        }
        super.visit(n, arg);
    }

    public void visit(MethodCallExpr n, Object arg) {
        this.methodCallExprs.add(n);
        super.visit(n, arg);
    }

    public static String fieldName(String getsetName) {
        if (!"get".equals(getsetName.substring(0, 3)) && !"set".equals(getsetName.substring(0, 3))) {
            throw new IllegalArgumentException("Invalid getter or setter name : " + getsetName);
        }
        return String.format("%s%s", getsetName.substring(3, 4).toLowerCase(), getsetName.substring(4));
    }

    @Override
    public List<AnnotationExpr> getAnnotationExprs() {
        return this.annotationExprs;
    }

    @Override
    public List<MethodCallExpr> getMethodCallExprs() {
        return this.methodCallExprs;
    }

    public List<ArrayCreationExpr> getArrayCreationExprs() {
        return new ArrayList<ArrayCreationExpr>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldInfo {
        private Type type;
        private String name;
        private List<AnnotationExpr> annotationExprs;
        private MethodDeclaration sourceDeclaration;

        private FieldInfo(Type type, String name, List<AnnotationExpr> annotationExprs, MethodDeclaration sourceDeclaration) {
            this.type = type;
            this.name = name;
            this.annotationExprs = annotationExprs;
            this.sourceDeclaration = sourceDeclaration;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public List<AnnotationExpr> getAnnotationExprs() {
            return this.annotationExprs;
        }

        public MethodDeclaration getSourceDeclaration() {
            return this.sourceDeclaration;
        }
    }
}

