/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator;

import japa.parser.ParseException;
import japa.parser.Parser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.visitor.DumpVisitorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.chromattic.testgenerator.GroovyOutputFormat;
import org.chromattic.testgenerator.SourceUtil;
import org.chromattic.testgenerator.TestRef;
import org.chromattic.testgenerator.TestSerializer;
import org.chromattic.testgenerator.builder.GroovyFromJavaSourceChromatticBuilder;
import org.chromattic.testgenerator.builder.GroovyFromJavaSourceTestBuilder;
import org.chromattic.testgenerator.visitor.renderer.GroovyCompatibilityFactory;
import org.chromattic.testgenerator.visitor.renderer.GroovyPropertiesFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedAnnotationTypes(value={"*"})
public class GroovyGeneratorProcessor
extends AbstractProcessor {
    private Filer filer;

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        this.filer = this.processingEnv.getFiler();
        TestSerializer serializer = new TestSerializer();
        if (roundEnvironment.processingOver()) {
            try {
                Class<?> c = Class.forName("load.Ref");
                for (Module module : Module.values()) {
                    InputStream is = c.getResource("testsRef-" + module.get() + ".xml").openStream();
                    for (TestRef ref : serializer.getClassNames(is)) {
                        this.writeGroovySource(GroovyOutputFormat.GETTER_SETTER, ref, module.get());
                        this.writeGroovySource(GroovyOutputFormat.PROPERTIES, ref, module.get());
                        this.writeGroovySource(GroovyOutputFormat.CHROMATTIC, ref, module.get());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void writeGroovySource(GroovyOutputFormat format, TestRef ref, String module) throws ParseException {
        try {
            switch (format) {
                case GETTER_SETTER: {
                    this.writeGroovyTest(format, ref, new GroovyCompatibilityFactory(), module);
                    break;
                }
                case PROPERTIES: {
                    this.writeGroovyTest(format, ref, new GroovyPropertiesFactory(), module);
                    break;
                }
                case CHROMATTIC: {
                    Set<String> chromatticClassNames = ref.getChromatticObject();
                    for (String chromatticQualifiedClassName : chromatticClassNames) {
                        String name = ((Object)format.getPackageName(chromatticQualifiedClassName)).toString().replace(".", "/") + "/" + format.javaFileName(chromatticQualifiedClassName);
                        InputStream chromatticIs = this.filer.getResource(StandardLocation.SOURCE_PATH, "", module + "/src/test/java/" + name).openInputStream();
                        CompilationUnit chromatticUnit = Parser.parse(chromatticIs);
                        try {
                            OutputStream chromatticOs = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, format.getPackageName(chromatticQualifiedClassName) + ".groovy", format.getClassName(chromatticQualifiedClassName) + ".groovy", new Element[0]).openOutputStream();
                            GroovyFromJavaSourceChromatticBuilder chromatticBuilder = new GroovyFromJavaSourceChromatticBuilder(chromatticUnit);
                            chromatticBuilder.build();
                            SourceUtil.writeSource(chromatticBuilder.toString(), chromatticOs);
                        }
                        catch (FilerException ignore) {}
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeGroovyTest(GroovyOutputFormat format, TestRef ref, DumpVisitorFactory factory, String module) throws IOException, ParseException {
        String name = ((Object)format.getPackageName(ref)).toString().replace(".", "/") + "/" + format.javaFileName(ref);
        InputStream testIs = this.filer.getResource(StandardLocation.SOURCE_PATH, "", module + "/src/test/java/" + name).openInputStream();
        CompilationUnit testUnit = Parser.parse(testIs);
        FileObject jfo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, format.getPackageName(ref), format.groovyFileName(ref), new Element[0]);
        GroovyFromJavaSourceTestBuilder testBuilder = new GroovyFromJavaSourceTestBuilder(testUnit, format.testName(ref), ref.getChromatticObject());
        testBuilder.build(factory, new ArrayList<String>());
        SourceUtil.writeSource(testBuilder.toString(), jfo.openOutputStream());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Module {
        CORE("core"),
        MOTEAMODEL("metamodel");

        private String name;

        private Module(String name) {
            this.name = name;
        }

        String get() {
            return this.name;
        }
    }
}

