/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.chromattic.testgenerator.TestRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSerializer {
    private static final String ROOT_TAG = "testgen";
    private static final String TEST_TAG = "test";

    public void writeTo(Writer writer, Set<TestRef> names) throws IOException {
        this.startTag(writer, ROOT_TAG);
        for (TestRef ref : names) {
            this.startTag(writer, TEST_TAG);
            this.writeName(writer, ref.getName());
            this.startTag(writer, "chromatticObjects");
            for (String chromatticObjectName : ref.getChromatticObject()) {
                this.writeChromatticObject(writer, chromatticObjectName);
            }
            this.endTag(writer, "chromatticObjects");
            this.endTag(writer, TEST_TAG);
        }
        this.endTag(writer, ROOT_TAG);
    }

    private void startTag(Writer writer, String tagName) throws IOException {
        writer.append(String.format("<%s>", tagName));
    }

    private void endTag(Writer writer, String tagName) throws IOException {
        writer.append(String.format("</%s>", tagName));
    }

    private void writeName(Writer writer, String name) throws IOException {
        this.startTag(writer, "name");
        this.plaintext(writer, name);
        this.endTag(writer, "name");
    }

    private void writeChromatticObject(Writer writer, String objectName) throws IOException {
        this.startTag(writer, "chromatticObject");
        this.plaintext(writer, objectName);
        this.endTag(writer, "chromatticObject");
    }

    private void plaintext(Writer writer, CharSequence text) throws IOException {
        writer.append(text);
    }

    public List<TestRef> getClassNames(InputStream is) {
        ArrayList<TestRef> refs = new ArrayList<TestRef>();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            TestRef currentTestRef = null;
            while (reader.hasNext()) {
                reader.next();
                if (reader.getEventType() != 1) continue;
                String name = reader.getName().toString();
                if (name.equals("name")) {
                    reader.next();
                    currentTestRef = new TestRef(reader.getText());
                    refs.add(currentTestRef);
                    continue;
                }
                if (!name.equals("chromatticObject")) continue;
                reader.next();
                currentTestRef.getChromatticObject().add(reader.getText());
            }
            return refs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

