/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator.visitor.renderer;

import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.visitor.VoidVisitor;
import org.chromattic.testgenerator.visitor.renderer.GroovyCompatibilityVisitor;

public class GroovyPropertiesVisitor
extends GroovyCompatibilityVisitor {
    public void visit(MethodCallExpr n, Object arg) {
        if (n.getScope() != null) {
            n.getScope().accept((VoidVisitor)this, arg);
            this.printer.print(".");
        }
        if (this.isGetter(n)) {
            this.printer.print(this.decapitalizeFromGetterSetter(n.getName()));
        } else if (this.isSetter(n)) {
            this.printer.print(this.decapitalizeFromGetterSetter(n.getName()));
            this.printer.print(" = ");
            ((Expression)n.getArgs().iterator().next()).accept((VoidVisitor)this, arg);
        } else {
            this.printer.print(n.getName());
            this.printArguments(n.getArgs(), arg);
        }
    }

    private boolean isGetter(MethodCallExpr methodCallExpr) {
        if (methodCallExpr.getName().length() < 4) {
            return false;
        }
        return methodCallExpr.getName().startsWith("get") && (methodCallExpr.getArgs() == null || methodCallExpr.getArgs().size() == 0);
    }

    private boolean isSetter(MethodCallExpr methodCallExpr) {
        if (methodCallExpr.getName().length() < 4) {
            return false;
        }
        return methodCallExpr.getName().startsWith("set") && methodCallExpr.getArgs() != null && methodCallExpr.getArgs().size() == 1;
    }

    private String decapitalizeFromGetterSetter(String name) {
        String fieldName = name.substring(3);
        if (fieldName == null || fieldName.length() == 0) {
            return fieldName;
        }
        if (fieldName.length() > 2 && Character.isUpperCase(fieldName.charAt(2)) && Character.isUpperCase(fieldName.charAt(1)) && Character.isUpperCase(fieldName.charAt(0))) {
            return fieldName;
        }
        return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
    }
}

