/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class HttpUtils
extends MonitoredObject {
    public final boolean ping(URL pingURL) {
        return this.isAvailable(this.testConnectivity(pingURL, null));
    }

    public final boolean ping(URL pingURL, HttpResult result) {
        return this.ping(pingURL, null, result);
    }

    public final boolean ping(URL pingURL, Map requestProperties, HttpResult result) {
        HttpResult responseResult = this.testConnectivity(pingURL, requestProperties);
        result.responseBody = responseResult.responseBody;
        result.responseCode = responseResult.responseCode;
        result.responseMessage = responseResult.responseMessage;
        return this.isAvailable(responseResult);
    }

    private HttpResult testConnectivity(URL url, Map requestProperties) {
        HttpResult result = new HttpResult();
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Connection", "close");
            if (requestProperties != null) {
                Iterator keys = requestProperties.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    connection.setRequestProperty(key, (String)requestProperties.get(key));
                    this.getMonitor().debug("Added property [" + key + "] = [" + (String)requestProperties.get(key) + "]", ((Object)((Object)this)).getClass().getName());
                }
            }
            connection.connect();
            result.responseBody = this.readFully(connection);
            connection.disconnect();
            result.responseCode = connection.getResponseCode();
            result.responseMessage = connection.getResponseMessage();
        }
        catch (IOException e) {
            result.responseCode = -1;
        }
        this.getMonitor().debug("Pinged [" + url + "], result = [" + result.responseCode + "]", ((Object)((Object)this)).getClass().getName());
        return result;
    }

    private boolean isAvailable(HttpResult responseResult) {
        boolean result = responseResult.responseCode != -1 && responseResult.responseCode < 300;
        return result;
    }

    private String readFully(HttpURLConnection connection) throws IOException {
        String responseBody = "";
        if (connection.getContentLength() != 0) {
            try {
                InputStream in = connection.getInputStream();
                if (in != null) {
                    responseBody = this.readStreamData(in);
                }
            }
            catch (IOException e) {
                InputStream in = connection.getErrorStream();
                if (in != null) {
                    responseBody = this.readStreamData(in);
                }
                throw e;
            }
        }
        return responseBody;
    }

    private String readStreamData(InputStream stream) throws IOException {
        int n;
        StringBuffer body = new StringBuffer();
        byte[] buf = new byte[256];
        while ((n = stream.read(buf)) != -1) {
            body.append(new String(buf, 0, n));
        }
        return body.toString();
    }

    public static class HttpResult {
        public int responseCode;
        public String responseMessage;
        public String responseBody;
    }
}

