/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.util.AntUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.configuration.AbstractConfiguration;
import org.codehaus.cargo.util.FileUtils;

public abstract class AbstractLocalConfiguration
extends AbstractConfiguration
implements LocalConfiguration {
    protected static final String RESOURCE_PATH = "/org/codehaus/cargo/container/internal/resources/";
    private List deployables = new ArrayList();
    private File home;
    private AntUtils antUtils;
    private ResourceUtils resourceUtils;
    private FileUtils fileUtils = new FileUtils();

    public AbstractLocalConfiguration(File home) {
        this.antUtils = new AntUtils();
        this.resourceUtils = new ResourceUtils();
        this.home = home;
        this.setProperty("cargo.protocol", "http");
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.servlet.port", "8080");
    }

    protected final FileUtils getFileUtils() {
        return this.fileUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    public synchronized void addDeployable(Deployable newDeployable) {
        this.deployables.add(newDeployable);
    }

    public List getDeployables() {
        return this.deployables;
    }

    public File getHome() {
        return this.home;
    }

    public void verifyProperties() {
        this.verifyServletPortProperty();
    }

    public final void configure(LocalContainer container) {
        try {
            this.doConfigure(container);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " " + this.getType().getType() + " configuration", e);
        }
    }

    protected abstract void doConfigure(LocalContainer var1) throws Exception;

    private void verifyServletPortProperty() {
        try {
            Integer.parseInt(this.getPropertyValue("cargo.servlet.port"));
        }
        catch (NumberFormatException e) {
            throw new ContainerException("Invalid port number [" + this.getPropertyValue("cargo.servlet.port") + "]. The port value must be an integer", e);
        }
    }

    public abstract /* synthetic */ ConfigurationType getType();

    public abstract /* synthetic */ ConfigurationCapability getCapability();
}

