/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.EJB;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractLocalDeployer;

public abstract class AbstractCopyingDeployer
extends AbstractLocalDeployer {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private boolean shouldDeployExpandedWARs = true;
    private List deployedDeployables = new ArrayList();

    public AbstractCopyingDeployer(LocalContainer container) {
        super(container);
    }

    public void setShouldDeployExpandedWARs(boolean flag) {
        this.shouldDeployExpandedWARs = flag;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void deploy(Deployable deployable) {
        if (!this.canBeDeployed(deployable)) {
            throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + this.getDeployableDir().getPath() + "]. The required web context is already in use" + " by another application.");
        }
        deployableDir = this.getDeployableDir();
        this.getMonitor().info("Deploying [" + deployable.getFile().getPath() + "] to [" + deployableDir.getPath() + "]...", this.getClass().getName());
        if (deployable.getType() == DeployableType.WAR) {
            if (!this.getContainer().getCapability().supportsDeployableType(DeployableType.WAR)) {
                throw new ContainerException("WAR archives are not supported for deployment in " + this.getContainer().getId() + ". Got [" + deployable.getFile() + "]");
            }
            try {
                if (!((WAR)deployable).isExpandedWar()) {
                    this.deployWar(deployableDir, (WAR)deployable);
                }
                if (!this.shouldDeployExpandedWARs) ** GOTO lbl34
                this.deployExpandedWar(deployableDir, (WAR)deployable);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + deployableDir.getPath() + "]", e);
            }
        } else if (deployable.getType() == DeployableType.EAR) {
            if (!this.getContainer().getCapability().supportsDeployableType(DeployableType.EAR)) {
                throw new ContainerException("EAR archives are not supported for deployment in " + this.getContainer().getId() + ". Got [" + deployable.getFile() + "]");
            }
            try {
                this.deployEar(deployableDir, (EAR)deployable);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + deployableDir.getPath() + "]", e);
            }
        } else if (deployable.getType() == DeployableType.EJB) {
            if (!this.getContainer().getCapability().supportsDeployableType(DeployableType.EJB)) {
                throw new ContainerException("EJB archives are not supported for deployment in " + this.getContainer().getId() + ". Got [" + deployable.getFile() + "]");
            }
            try {
                this.deployEjb(deployableDir, (EJB)deployable);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + deployableDir.getPath() + "]", e);
            }
        } else {
            throw new ContainerException("Only WAR, EJB and EAR are currently supported");
        }
lbl34:
        // 5 sources

        this.deployedDeployables.add(deployable);
    }

    protected boolean canBeDeployed(Deployable newDeployable) {
        Set newDeployableContextSet = AbstractCopyingDeployer.getWebContextsSet(newDeployable);
        int size = this.deployedDeployables.size();
        for (int i = 0; i < size; ++i) {
            Deployable deployedDeployable = (Deployable)this.deployedDeployables.get(i);
            Iterator contextIterator = AbstractCopyingDeployer.getWebContextsIterator(deployedDeployable);
            while (contextIterator.hasNext()) {
                Object context = contextIterator.next();
                if (!newDeployableContextSet.contains(context)) continue;
                return false;
            }
        }
        return true;
    }

    private static Iterator getWebContextsIterator(Deployable deployable) {
        Iterator<String> webContexts = null;
        webContexts = deployable.getType() == DeployableType.EAR ? ((EAR)deployable).getWebContexts() : (deployable.getType() == DeployableType.WAR ? Arrays.asList(((WAR)deployable).getContext()).iterator() : EMPTY_ITERATOR);
        return webContexts;
    }

    private static Set getWebContextsSet(Deployable deployable) {
        HashSet webContextSet = new HashSet();
        Iterator contextIterator = AbstractCopyingDeployer.getWebContextsIterator(deployable);
        while (contextIterator.hasNext()) {
            webContextSet.add(contextIterator.next());
        }
        return webContextSet;
    }

    public abstract File getDeployableDir();

    protected void deployEar(File deployableDir, EAR ear) throws Exception {
        this.getFileUtils().copyFile(ear.getFile(), new File(deployableDir, ear.getFile().getName()), null, true);
    }

    protected void deployEjb(File deployableDir, EJB ejb) throws Exception {
        this.getFileUtils().copyFile(ejb.getFile(), new File(deployableDir, ejb.getFile().getName()), null, true);
    }

    protected void deployWar(File deployableDir, WAR war) throws Exception {
        this.getFileUtils().copyFile(war.getFile(), new File(deployableDir, war.getFile().getName()), null, true);
    }

    protected void deployExpandedWar(File deployableDir, WAR war) throws Exception {
        Copy copyTask = (Copy)this.getAntUtils().createAntTask("copy");
        copyTask.setTodir(new File(deployableDir, war.getFile().getName()));
        FileSet fileSet = new FileSet();
        fileSet.setDir(war.getFile());
        copyTask.addFileset(fileSet);
        copyTask.setFailOnError(true);
        copyTask.setIncludeEmptyDirs(true);
        copyTask.setOverwrite(true);
        copyTask.execute();
    }
}

