/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import java.util.List;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.util.log.LoggedObject;

public abstract class AbstractDeployer
extends LoggedObject
implements Deployer {
    public void deploy(List deployables) {
        for (Deployable deployable : deployables) {
            this.deploy(deployable);
        }
    }

    public void deploy(Deployable deployable, DeployableMonitor monitor) {
        this.deploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForAvailability();
    }

    public void undeploy(Deployable deployable, DeployableMonitor monitor) {
        this.undeploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setLogger(this.getLogger());
        watchdog.watchForUnavailability();
    }

    public void deploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void start(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void stop(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void undeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void redeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }
}

