/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.spi.deployable.AbstractDeployable;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.log.Logger;

public class WAR
extends AbstractDeployable {
    private String context;
    private List<String> extraClasspath = new ArrayList<String>();

    public WAR(String war) {
        super(war);
    }

    public synchronized void setContext(String context) {
        String wellFormedContext = context.trim();
        while (wellFormedContext.contains("//")) {
            wellFormedContext = wellFormedContext.replace("//", "/");
        }
        while (wellFormedContext.startsWith("/")) {
            wellFormedContext = wellFormedContext.substring(1);
        }
        while (wellFormedContext.endsWith("/")) {
            wellFormedContext = wellFormedContext.substring(0, wellFormedContext.length() - 1);
        }
        this.context = wellFormedContext;
    }

    private void parseContext() {
        if (this.context == null) {
            String ctx = this.getFileHandler().getName(this.getFile());
            int warIndex = ctx.toLowerCase().lastIndexOf(".war");
            if (warIndex >= 0) {
                ctx = ctx.substring(0, warIndex);
            }
            this.getLogger().debug("Parsed web context = [" + ctx + "]", this.getClass().getName());
            this.setContext(ctx);
        }
    }

    public synchronized String getContext() {
        this.parseContext();
        return this.context;
    }

    @Override
    public DeployableType getType() {
        return DeployableType.WAR;
    }

    public synchronized void setExtraClasspath(String[] classpath) {
        this.extraClasspath.clear();
        if (classpath != null) {
            Collections.addAll(this.extraClasspath, classpath);
        }
    }

    public synchronized String[] getExtraClasspath() {
        return this.extraClasspath.toArray(new String[this.extraClasspath.size()]);
    }

    @Override
    public String getName() {
        return this.getContext();
    }

    public String getBaseFilename() {
        String baseFilename = this.getContext();
        if (baseFilename == null || baseFilename.trim().isEmpty() || baseFilename.matches("/+")) {
            this.getLogger().info("The WAR file has its context set to / and will therefore be deployed as ROOT.war", this.getClass().getName());
            baseFilename = "ROOT";
        } else {
            baseFilename = DefaultFileHandler.sanitizeFilename((String)baseFilename, (Logger)this.getLogger());
        }
        if (baseFilename.trim().isEmpty() || baseFilename.matches("/+")) {
            this.getLogger().info("The WAR file has its sanitized context set to [" + baseFilename + "] and will therefore be deployed as ROOT.war", this.getClass().getName());
            baseFilename = "ROOT";
        }
        return baseFilename;
    }

    @Override
    public String getFilename() {
        String filename = this.getBaseFilename();
        if (!this.isExpanded()) {
            filename = filename + ".war";
        }
        return filename;
    }
}

