/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.http.writer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class UrlEncodedFormWriter {
    private final StringBuilder formData = new StringBuilder();

    public void addField(String name, String value) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        if (this.formData.length() > 0) {
            this.formData.append("&");
        }
        this.formData.append(name + "=");
        if (value != null) {
            this.formData.append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
        }
    }

    public void write(OutputStream os) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("Output stream is required.");
        }
        try (DataOutputStream out = new DataOutputStream(os);){
            out.writeBytes(this.formData.toString());
            out.flush();
        }
    }

    public int getLength() {
        return this.formData.length();
    }
}

