/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration.builder;

import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.property.TransactionSupport;

public abstract class AbstractConfigurationBuilder
implements ConfigurationBuilder {
    @Override
    public String toConfigurationEntry(DataSource ds) {
        String returnVal = " ";
        switch (ds.getConnectionType()) {
            case "java.sql.Driver": {
                returnVal = this.buildEntryForDriverConfiguredDataSource(ds);
                break;
            }
            case "javax.sql.XADataSource": {
                returnVal = this.buildConfigurationEntryForXADataSourceConfiguredDataSource(ds);
                break;
            }
            default: {
                throw new IllegalArgumentException("Connection Type: " + ds.getConnectionType() + " not supported");
            }
        }
        return returnVal;
    }

    private String buildEntryForDriverConfiguredDataSource(DataSource ds) {
        String returnVal = null;
        if (ds.getTransactionSupport().equals(TransactionSupport.NO_TRANSACTION)) {
            returnVal = this.buildEntryForDriverConfiguredDataSourceWithNoTx(ds);
        } else if (ds.getTransactionSupport().equals(TransactionSupport.LOCAL_TRANSACTION)) {
            returnVal = this.buildEntryForDriverConfiguredDataSourceWithLocalTx(ds);
        } else if (ds.getTransactionSupport().equals(TransactionSupport.XA_TRANSACTION)) {
            returnVal = this.buildEntryForDriverConfiguredDataSourceWithXaTx(ds);
        } else {
            throw new IllegalArgumentException("Transaction support: " + ds.getTransactionSupport() + " not supported");
        }
        return returnVal;
    }

    public abstract String buildEntryForDriverConfiguredDataSourceWithXaTx(DataSource var1);

    public abstract String buildEntryForDriverConfiguredDataSourceWithLocalTx(DataSource var1);

    public abstract String buildEntryForDriverConfiguredDataSourceWithNoTx(DataSource var1);

    public abstract String buildConfigurationEntryForXADataSourceConfiguredDataSource(DataSource var1);
}

