/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.codehaus.cargo.container.internal.http.HttpResult;
import org.codehaus.cargo.util.log.LoggedObject;

public class HttpRequest
extends LoggedObject {
    protected static final int BUFFER_CHUNK_SIZE = 262144;
    private static final NonceCounter NONCE_COUNTER = new NonceCounter();
    private URL url;
    private long timeout;
    private String username;
    private String password;
    private Map<String, String> requestProperties;
    private String requestBody;

    public HttpRequest(URL url) {
        this(url, 0L);
    }

    public HttpRequest(URL url, long timeout) {
        this.url = url;
        this.timeout = timeout;
        this.requestProperties = new HashMap<String, String>();
    }

    public void addRequestProperty(String propertyName, String propertyValue) {
        this.requestProperties.put(propertyName, propertyValue);
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public HttpResult get() throws IOException {
        return this.connect("GET", null);
    }

    public HttpResult post() throws IOException {
        return this.connect("POST", null);
    }

    public HttpResult put() throws IOException {
        return this.connect("PUT", null);
    }

    public HttpResult delete() throws IOException {
        return this.connect("DELETE", null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResult connect(String httpMethod, String digestData) throws IOException {
        this.getLogger().debug("Calling [" + this.url + "] with timeout " + this.timeout, ((Object)((Object)this)).getClass().getName());
        HttpURLConnection connection = null;
        try {
            block47: {
                if (this.url.getProtocol().equalsIgnoreCase("https")) {
                    TrustManager[] trustAll = new TrustManager[]{new PermissiveTrustManager()};
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(null, trustAll, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                    connection = (HttpsURLConnection)this.url.openConnection();
                    PermissiveHostnameVerifier verifyAll = new PermissiveHostnameVerifier();
                    ((HttpsURLConnection)connection).setHostnameVerifier(verifyAll);
                } else {
                    connection = (HttpURLConnection)this.url.openConnection();
                }
                connection.setRequestMethod(httpMethod);
                connection.setAllowUserInteraction(false);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                if (this.timeout != 0L) {
                    connection.setReadTimeout((int)this.timeout);
                    connection.setConnectTimeout((int)this.timeout);
                }
                if (digestData != null) {
                    connection.setRequestProperty("Authorization", digestData);
                    this.getLogger().debug("Set Digest authentication", ((Object)((Object)this)).getClass().getName());
                } else {
                    Object userInfo = this.url.getUserInfo();
                    if (userInfo != null) {
                        userInfo = Base64.getEncoder().encodeToString(((String)userInfo).getBytes(StandardCharsets.UTF_8));
                        connection.setRequestProperty("Authorization", "Basic " + (String)userInfo);
                        this.getLogger().debug("Set Basic authentication based on URL user information", ((Object)((Object)this)).getClass().getName());
                    } else if (this.username != null && !this.username.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(this.username).append(':');
                        if (this.password != null) {
                            stringBuilder.append(this.password);
                        }
                        userInfo = Base64.getEncoder().encodeToString(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                        connection.setRequestProperty("Authorization", "Basic " + (String)userInfo);
                        this.getLogger().debug("Set Basic authentication based on username/password", ((Object)((Object)this)).getClass().getName());
                    }
                }
                if (this.requestProperties != null) {
                    for (Map.Entry entry : this.requestProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        connection.setRequestProperty(key, value);
                        this.getLogger().debug("Added property [" + key + "] = [" + value + "]", ((Object)((Object)this)).getClass().getName());
                    }
                }
                this.getLogger().debug("Sending request and writing to output stream if necessary", ((Object)((Object)this)).getClass().getName());
                try {
                    this.writeOutputStream(connection);
                }
                catch (IOException e) {
                    if (connection.getResponseCode() != 401) {
                        throw e;
                    }
                    String string = connection.getHeaderField("WWW-Authenticate");
                    if (string == null) throw e;
                    if (string.startsWith("Digest ")) break block47;
                    throw e;
                }
            }
            int responseCode = connection.getResponseCode();
            this.getLogger().debug("Got response code [" + responseCode + "]", ((Object)((Object)this)).getClass().getName());
            if (responseCode == 401) {
                String string = connection.getHeaderField("WWW-Authenticate");
                if (digestData == null && string != null && string.startsWith("Digest ")) {
                    void var5_20;
                    this.getLogger().debug("Server requests Digest authentication", ((Object)((Object)this)).getClass().getName());
                    String realm = HttpRequest.extractHeaderComponent(string, "realm");
                    String qop = HttpRequest.extractHeaderComponent(string, "qop");
                    String nonce = HttpRequest.extractHeaderComponent(string, "nonce");
                    String opaque = HttpRequest.extractHeaderComponent(string, "opaque");
                    String algorithm = HttpRequest.extractHeaderComponent(string, "algorithm");
                    if (realm == null) {
                        HttpResult result = new HttpResult();
                        result.setResponseCode(-1);
                        result.setResponseMessage("The server requested a Digest authentication but the realm is not provided");
                        HttpResult httpResult = result;
                        return httpResult;
                    }
                    if (nonce == null) {
                        HttpResult result = new HttpResult();
                        result.setResponseCode(-1);
                        result.setResponseMessage("The server requested a Digest authentication but the nonce is not provided");
                        HttpResult httpResult = result;
                        return httpResult;
                    }
                    if (qop != null && !"auth".equals(qop)) {
                        HttpResult result = new HttpResult();
                        result.setResponseCode(-1);
                        result.setResponseMessage("The server requested a Digest authentication but the qop is set to [" + qop + "] instead of [auth]");
                        HttpResult httpResult = result;
                        return httpResult;
                    }
                    if (algorithm == null) {
                        algorithm = "MD5";
                    }
                    MessageDigest digest = MessageDigest.getInstance(algorithm);
                    String ha1 = this.username + ":" + realm + ":" + this.password;
                    byte[] hash = digest.digest(ha1.getBytes(StandardCharsets.UTF_8));
                    StringBuilder sb = new StringBuilder();
                    for (byte hashByte : hash) {
                        sb.append(String.format("%02x", hashByte));
                    }
                    ha1 = sb.toString();
                    String uriPath = this.url.getPath();
                    String uriQuery = this.url.getQuery();
                    String uri = uriQuery != null ? uriPath + "?" + uriQuery : uriPath;
                    String ha2 = httpMethod;
                    ha2 = ha2 + ":" + uri;
                    hash = digest.digest(ha2.getBytes(StandardCharsets.UTF_8));
                    sb = new StringBuilder();
                    for (byte by : hash) {
                        sb.append(String.format("%02x", by));
                    }
                    ha2 = sb.toString();
                    String nc = NONCE_COUNTER.count(nonce);
                    String cnonce = String.format("%08x", (long)(Math.random() * 4.294967295E9));
                    cnonce = cnonce.substring(cnonce.length() - 8);
                    String ha3 = qop != null ? ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2 : ha1 + ":" + nonce + ":" + ha2;
                    hash = digest.digest(ha3.getBytes(StandardCharsets.UTF_8));
                    sb = new StringBuilder();
                    for (byte hashByte : hash) {
                        sb.append(String.format("%02x", hashByte));
                    }
                    ha3 = sb.toString();
                    String string2 = "Digest username=\"" + this.username + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"" + uri + "\", algorithm=" + algorithm + ", nc=" + nc + ", cnonce=\"" + cnonce + "\", response=\"" + ha3 + "\"";
                    if (qop != null) {
                        String string3 = string2 + ", qop=\"" + qop + "\"";
                    }
                    if (opaque != null) {
                        void var5_18;
                        String string4 = (String)var5_18 + ", opaque=\"" + opaque + "\"";
                    }
                    this.getLogger().debug("Digest authentication with ha=" + ha1 + ", ha2=" + ha2, ((Object)((Object)this)).getClass().getName());
                    HttpResult httpResult = this.connect(httpMethod, (String)var5_20);
                    return httpResult;
                }
                this.getLogger().debug("Server requests [" + string + "] authentication", ((Object)((Object)this)).getClass().getName());
            }
            HttpResult httpResult = new HttpResult();
            httpResult.setResponseCode(responseCode);
            httpResult.setResponseMessage(connection.getResponseMessage());
            httpResult.setResponseBody(this.readFully(connection));
            HttpResult httpResult2 = httpResult;
            return httpResult2;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected void writeOutputStream(HttpURLConnection connection) throws IOException {
        block12: {
            if (this.requestBody != null) {
                connection.setDoOutput(true);
                try (OutputStream outputStream = connection.getOutputStream();
                     BufferedWriter httpRequestBodyWriter = new BufferedWriter(new OutputStreamWriter(outputStream));){
                    httpRequestBodyWriter.write(this.requestBody);
                    break block12;
                }
            }
            connection.connect();
        }
    }

    private String readFully(HttpURLConnection connection) throws IOException {
        String responseBody = "";
        if (connection.getContentLength() != 0) {
            Charset charset = HttpRequest.extractCharset(connection.getContentType());
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                InputStream in = connection.getInputStream();
                if (in != null) {
                    responseBody = this.readStreamData(in, charset);
                }
            } else {
                InputStream in = connection.getErrorStream();
                if (in != null) {
                    responseBody = this.readStreamData(in, charset);
                }
            }
        }
        return responseBody;
    }

    protected static Charset extractCharset(String contentType) {
        int charsetStart;
        Charset charset = StandardCharsets.UTF_8;
        if (contentType != null && (charsetStart = contentType.indexOf("; charset=")) > 0) {
            try {
                charset = Charset.forName(contentType.substring(charsetStart + 10));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return charset;
    }

    private String readStreamData(InputStream stream, Charset charset) throws IOException {
        String splitResponse;
        int httpHeaderBodySeparation;
        int n;
        InputStreamReader reader = new InputStreamReader(stream, charset);
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[1024];
        while ((n = reader.read(chars, 0, chars.length)) != -1) {
            sb.append(chars, 0, n);
        }
        String response = sb.toString().replaceAll("\\r\\n?", "\n");
        if (response.startsWith("HTTP/") && (httpHeaderBodySeparation = response.indexOf("\n\n")) != -1 && (httpHeaderBodySeparation = (splitResponse = response.substring(httpHeaderBodySeparation + 2)).indexOf(10)) != -1) {
            response = splitResponse.substring(httpHeaderBodySeparation + 1);
        }
        return response;
    }

    protected static String extractHeaderComponent(String header, String component) {
        String fullComponent = component + "=\"";
        int fullComponentLength = fullComponent.length();
        int index1 = header.indexOf(fullComponent);
        if (index1 == -1) {
            return null;
        }
        int index2 = header.indexOf(34, index1 + fullComponentLength);
        if (index2 == -1) {
            return null;
        }
        return header.substring(index1 + fullComponentLength, index2);
    }

    private static class PermissiveHostnameVerifier
    implements HostnameVerifier {
        private PermissiveHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    private static class NonceCounter {
        private final int maxLruCacheSizeLimit = 1000;
        private Map<String, Integer> nonces = new LinkedHashMap<String, Integer>(1001, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
                return this.size() > 1000;
            }
        };

        public synchronized String count(String nonce) {
            Integer count = this.nonces.get(nonce);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            this.nonces.put(nonce, count);
            return String.format("%08x", count);
        }
    }
}

