/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import org.codehaus.cargo.container.ContainerException;

public final class JdkUtils {
    private JdkUtils() {
    }

    public static File getToolsJar() throws FileNotFoundException {
        String javaHome = System.getProperty("java.home");
        File toolsJar = JdkUtils.getToolsJar(javaHome);
        if (!toolsJar.isFile()) {
            throw new FileNotFoundException(toolsJar.getAbsolutePath());
        }
        return toolsJar;
    }

    public static File getToolsJar(String javaHome) {
        File jdkHome = new File(javaHome).getAbsoluteFile();
        if (jdkHome.getName().equals("jre")) {
            jdkHome = jdkHome.getParentFile();
        }
        File libDir = new File(jdkHome, "lib");
        File toolsJar = new File(libDir, "tools.jar");
        return toolsJar;
    }

    public static boolean isOSX() {
        return System.getProperty("mrj.version") != null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static int getMajorJavaVersion() {
        return JdkUtils.parseMajorJavaVersion(System.getProperty("java.version"));
    }

    public static int parseMajorJavaVersion(String version) {
        String jvmVersion = version.replaceAll("^\"?(1\\.)?([0-9]+).*", "$2");
        return Integer.parseInt(jvmVersion);
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new ContainerException("Interruption during sleep", e);
        }
    }
}

