/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.spi.deployable.AbstractDeployablewithSettableName;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.DefaultEarArchive;

public class EAR
extends AbstractDeployablewithSettableName {
    private Map<String, String> webapps;

    public EAR(String ear) {
        super(ear);
    }

    private void parseWebApps() {
        if (this.webapps == null) {
            HashMap<String, String> webapps = new HashMap<String, String>();
            try {
                DefaultEarArchive ear = new DefaultEarArchive(this.getFile());
                ApplicationXml applicationXml = ear.getApplicationXml();
                for (String webUri : applicationXml.getWebModuleUris()) {
                    String context = applicationXml.getWebModuleContextRoot(webUri);
                    if (context == null) {
                        throw new ContainerException("Your application.xml must define a <context-root> element in the <web> module definition.");
                    }
                    if (context.startsWith("/")) {
                        context = context.substring(1);
                    }
                    this.getLogger().debug("Found Web URI [" + webUri + "], context [" + context + "]", this.getClass().getName());
                    webapps.put(context, webUri);
                }
            }
            catch (Exception e) {
                throw new ContainerException("Failed to parse webapps from [" + this.getFile() + "] EAR.", e);
            }
            this.webapps = webapps;
        }
    }

    public synchronized List<String> getWebContexts() {
        this.parseWebApps();
        return new ArrayList<String>(this.webapps.keySet());
    }

    public synchronized List<String> getWebUris() {
        this.parseWebApps();
        return new ArrayList<String>(this.webapps.values());
    }

    public synchronized String getWebUri(String context) {
        this.parseWebApps();
        return this.webapps.get(context);
    }

    @Override
    public DeployableType getType() {
        return DeployableType.EAR;
    }
}

