/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.installer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.installer.Installer;
import org.codehaus.cargo.container.installer.Proxy;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;
import org.codehaus.cargo.util.log.Logger;

public class ZipURLInstaller
extends LoggedObject
implements Installer {
    private URL remoteLocation;
    private String downloadDir;
    private String extractDir;
    private Proxy proxy;
    private FileHandler fileHandler;

    public ZipURLInstaller(URL remoteLocation) {
        this(remoteLocation, null, null);
    }

    public ZipURLInstaller(URL remoteLocation, String downloadDir, String extractDir) {
        this.remoteLocation = remoteLocation;
        this.downloadDir = downloadDir;
        this.extractDir = extractDir;
        this.fileHandler = new DefaultFileHandler();
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.fileHandler.setLogger(logger);
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public void setExtractDir(String extractDir) {
        this.extractDir = extractDir;
    }

    public String getDownloadDir() {
        if (this.downloadDir == null) {
            return this.getFileHandler().getTmpPath("installs");
        }
        return this.downloadDir;
    }

    public String getDownloadFile() {
        return this.getFileHandler().append(this.getDownloadDir(), this.getSourceFileName());
    }

    public String getExtractDir() {
        String extractDir = this.extractDir == null ? this.getFileHandler().getTmpPath("installs") : this.extractDir;
        String name = this.getSourceFileName();
        int dotPos = name.lastIndexOf(".");
        if (dotPos > -1) {
            name = name.substring(0, dotPos);
        }
        if (name.endsWith(".tar")) {
            name = name.substring(0, name.length() - 4);
        }
        return this.getFileHandler().append(extractDir, name);
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    @Override
    public void install() {
        if (!this.isAlreadyExtracted()) {
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is not yet installed.", this.getClass().getName());
            String targetFile = this.getFileHandler().append(this.getDownloadDir(), this.getSourceFileName());
            if (this.getFileHandler().isDirectory(targetFile)) {
                throw new ContainerException("Target file [" + targetFile + "] already exists as a directory, either delete it or change the ZipURLInstaller target folder or file name");
            }
            if (!this.getFileHandler().exists(targetFile)) {
                this.getLogger().debug("Container [" + this.getSourceFileName() + "] is not yet downloaded.", this.getClass().getName());
                this.download();
            }
            try {
                this.getLogger().debug("Container [" + this.getSourceFileName() + "] is downloaded, now unpacking.", this.getClass().getName());
                this.unpack();
            }
            catch (Exception e) {
                this.getLogger().debug("Container [" + this.getSourceFileName() + "] is broken.", this.getClass().getName());
                this.getFileHandler().delete(targetFile);
                this.download();
                try {
                    this.getLogger().debug("As the container was broken, also deleting [" + this.getExtractDir() + "] before extraction.", this.getClass().getName());
                    this.getFileHandler().delete(this.getExtractDir());
                    this.unpack();
                }
                catch (Exception ee) {
                    throw new ContainerException("Failed to unpack [" + this.getSourceFileName() + "]", ee);
                }
            }
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is unpacked, now registering.", this.getClass().getName());
            this.registerInstallation();
        } else {
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is already installed", this.getClass().getName());
            this.getLogger().debug("Using container installation dir [" + this.getExtractDir() + "]", this.getClass().getName());
        }
    }

    public void registerInstallation() {
        try {
            this.getFileHandler().writeTextFile(this.getFileHandler().append(this.getExtractDir(), ".cargo"), "Do not remove this file", StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAlreadyDownloaded() {
        boolean isDownloaded = false;
        String targetFile = this.getFileHandler().append(this.getDownloadDir(), this.getSourceFileName());
        if (this.getFileHandler().exists(targetFile)) {
            isDownloaded = true;
        }
        return isDownloaded;
    }

    public boolean isAlreadyExtracted() {
        boolean isExtracted = false;
        String timestampFile = this.getFileHandler().append(this.getExtractDir(), ".cargo");
        if (this.getFileHandler().exists(timestampFile)) {
            isExtracted = true;
        }
        return isExtracted;
    }

    @Override
    public String getHome() {
        if (!this.isAlreadyExtracted()) {
            throw new ContainerException("Failed to get container installation home as the container has not yet been installed. Please call install() first.");
        }
        String targetDir = this.getExtractDir();
        String[] files = this.getFileHandler().getChildren(targetDir, new String[0]);
        int nbDirectories = 0;
        String foundDirectory = null;
        for (String file : files) {
            if (!this.getFileHandler().isDirectory(file) || "PaxHeaders.X".equals(this.getFileHandler().getName(file))) continue;
            ++nbDirectories;
            foundDirectory = file;
        }
        String home = nbDirectories != 1 ? targetDir : foundDirectory;
        return home;
    }

    private void unpack() throws Exception {
        String source = this.getFileHandler().append(this.getDownloadDir(), this.getSourceFileName());
        this.getLogger().info("Installing container [" + source + "] in [" + this.getExtractDir() + "]", this.getClass().getName());
        if (source.endsWith(".7z")) {
            SevenZArchiveEntry sevenZEntry;
            SevenZFile sevenZFile = new SevenZFile(new File(source));
            while ((sevenZEntry = sevenZFile.getNextEntry()) != null) {
                String destinationEntry = this.getFileHandler().append(this.getExtractDir(), DefaultFileHandler.sanitizeFilename((String)sevenZEntry.getName(), (Logger)this.getLogger()));
                if (sevenZEntry.isDirectory()) {
                    this.getFileHandler().mkdirs(destinationEntry);
                    continue;
                }
                String parent = this.getFileHandler().getParent(destinationEntry);
                if (!this.getFileHandler().isDirectory(parent)) {
                    this.getFileHandler().mkdirs(parent);
                }
                OutputStream destinationFileOutputStream = this.getFileHandler().getOutputStream(destinationEntry);
                try {
                    int length;
                    byte[] sevenZContent = new byte[262144];
                    while ((length = sevenZFile.read(sevenZContent)) != -1) {
                        destinationFileOutputStream.write(sevenZContent, 0, length);
                    }
                }
                finally {
                    if (destinationFileOutputStream == null) continue;
                    destinationFileOutputStream.close();
                }
            }
        } else {
            try (BufferedInputStream sourceInputStream = new BufferedInputStream(this.getFileHandler().getInputStream(source));){
                boolean compressedStream;
                try {
                    CompressorStreamFactory.detect((InputStream)sourceInputStream);
                    compressedStream = true;
                }
                catch (CompressorException e) {
                    compressedStream = false;
                }
                if (compressedStream) {
                    CompressorStreamFactory csf = new CompressorStreamFactory();
                    try (BufferedInputStream decompressedInputStream = new BufferedInputStream((InputStream)csf.createCompressorInputStream((InputStream)sourceInputStream));){
                        this.unpackStream(decompressedInputStream);
                    }
                }
                this.unpackStream(sourceInputStream);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unpackStream(InputStream sourceInputStream) throws Exception {
        ArchiveStreamFactory asf = new ArchiveStreamFactory();
        try (ArchiveInputStream dearchivedInputStream = asf.createArchiveInputStream(sourceInputStream);){
            ArchiveEntry archiveEntry;
            while ((archiveEntry = dearchivedInputStream.getNextEntry()) != null) {
                String destinationEntry = this.getFileHandler().append(this.getExtractDir(), DefaultFileHandler.sanitizeFilename((String)archiveEntry.getName(), (Logger)this.getLogger()));
                if (archiveEntry.isDirectory()) {
                    this.getFileHandler().mkdirs(destinationEntry);
                    continue;
                }
                String parent = this.getFileHandler().getParent(destinationEntry);
                if (!this.getFileHandler().isDirectory(parent)) {
                    this.getFileHandler().mkdirs(parent);
                }
                OutputStream destinationFileOutputStream = this.getFileHandler().getOutputStream(destinationEntry);
                try {
                    this.getFileHandler().copy((InputStream)dearchivedInputStream, destinationFileOutputStream);
                }
                finally {
                    if (destinationFileOutputStream == null) continue;
                    destinationFileOutputStream.close();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() {
        block10: {
            Map<String, String> previousProperties = null;
            try {
                if (this.proxy != null) {
                    previousProperties = this.proxy.configure();
                }
                this.doDownload();
            }
            catch (Exception e) {
                if (this.proxy != null) {
                    try {
                        this.proxy.clear(previousProperties);
                        this.doDownload();
                        break block10;
                    }
                    catch (Exception ee) {
                        throw new ContainerException("Failed to download [" + this.remoteLocation + "]", ee);
                    }
                }
                throw new ContainerException("Failed to download [" + this.remoteLocation + "]", e);
            }
            finally {
                if (this.proxy != null) {
                    this.proxy.clear(previousProperties);
                }
            }
        }
    }

    protected void doDownload() throws IOException {
        String downloadDir = this.getDownloadDir();
        if (!this.getFileHandler().exists(downloadDir)) {
            this.getFileHandler().mkdirs(downloadDir);
        }
        String target = this.getFileHandler().append(downloadDir, this.getSourceFileName());
        this.getLogger().info("Downloading container from [" + this.remoteLocation + "] to [" + target + "]", this.getClass().getName());
        URLConnection connection = this.remoteLocation.openConnection();
        connection.addRequestProperty("Accept", "*/*");
        connection.addRequestProperty("Accept-Encoding", "identity");
        connection.setUseCaches(false);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setInstanceFollowRedirects(true);
            String userInfo = this.remoteLocation.getUserInfo();
            if (userInfo != null) {
                connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8)));
            }
        }
        try (InputStream httpStream = connection.getInputStream();
             OutputStream fileStream = this.getFileHandler().getOutputStream(target);){
            this.getFileHandler().copy(httpStream, fileStream);
        }
        long remoteTimestamp = connection.getLastModified();
        if (remoteTimestamp != 0L) {
            File targetFile = new File(target);
            targetFile.setLastModified(remoteTimestamp);
        }
    }

    protected String getSourceFileName() {
        int slashPos = this.remoteLocation.getPath().lastIndexOf(47);
        String name = this.remoteLocation.getPath();
        if (slashPos > -1) {
            name = this.remoteLocation.getPath().substring(slashPos + 1);
        }
        return name;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

