/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.util.log.LoggedObject;

public class DeployerWatchdog
extends LoggedObject
implements DeployableMonitorListener {
    private DeployableMonitor monitor;
    private boolean isDeployed;

    public DeployerWatchdog(DeployableMonitor monitor) {
        this.monitor = monitor;
        monitor.registerListener(this);
    }

    @Override
    public void deployed() {
        this.isDeployed = true;
    }

    @Override
    public void undeployed() {
        this.isDeployed = false;
    }

    public void watchForAvailability() {
        this.watch(true);
    }

    public void watchForUnavailability() {
        this.watch(false);
    }

    public void watch(boolean shouldWatchForAvailability) {
        try {
            boolean bl;
            boolean exitCondition;
            long startTime = System.currentTimeMillis();
            do {
                if (System.currentTimeMillis() - startTime > this.monitor.getTimeout()) {
                    String message = "Deployable [" + this.monitor.getDeployableName() + "] failed to finish " + (shouldWatchForAvailability ? "deploying" : "undeploying") + " within the timeout period [" + this.monitor.getTimeout() + "]. The Deployable state is thus unknown.";
                    this.getLogger().info(message, this.getClass().getName());
                    throw new ContainerException(message);
                }
                Thread.sleep(1000L);
                this.monitor.monitor();
                if (shouldWatchForAvailability) {
                    if (!this.isDeployed) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = this.isDeployed;
            } while (exitCondition = bl);
        }
        catch (InterruptedException e) {
            throw new ContainerException("Failed to monitor deployment", e);
        }
    }
}

